/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.discovery;

import com.paterva.maltego.discovery.DiscoveryItems;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.util.FastURL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransformServerListing
extends TransformServerDetail {
    private String _description;
    private Map<PublicWebService, String> _webService;
    private Set<TransformDescriptor> _transforms;
    private Set<MaltegoEntitySpec> _entities;
    private Set<TransformSet> _sets;
    private Set<DiscoveryItems> _items;
    private Map<TransformDescriptor, HubSeedDescriptor> _duplicateTransforms;
    private boolean _isFailed = false;

    public TransformServerListing(String seedUrl, FastURL url) {
        super(seedUrl, url);
    }

    public TransformServerListing(String seedUrl, FastURL url, FastURL v3url, String name, ProtocolVersion protocolVersion, String disclaimer) {
        super(seedUrl, url, v3url, name, protocolVersion, disclaimer);
    }

    public TransformServerListing(TransformServerDetail ref) {
        super(ref.getSeedUrl(), ref.getBaseUrl(), ref.getV3Url(), ref.getName(), ref.getProtocolVersion(), ref.getDisclaimer());
        this.setAuthentication(ref.getAuthentication());
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public Map<PublicWebService, String> getPublicWebServices() {
        if (this._webService == null) {
            this._webService = new HashMap<PublicWebService, String>();
        }
        return this._webService;
    }

    public Set<TransformDescriptor> getTransforms() {
        if (this._transforms == null) {
            this._transforms = new HashSet<TransformDescriptor>();
        }
        return this._transforms;
    }

    public Set<MaltegoEntitySpec> getEntities() {
        if (this._entities == null) {
            this._entities = new HashSet<MaltegoEntitySpec>();
        }
        return this._entities;
    }

    public Set<TransformSet> getSets() {
        if (this._sets == null) {
            this._sets = new HashSet<TransformSet>();
        }
        return this._sets;
    }

    public Set<DiscoveryItems> getMtzDiscoveryItems() {
        if (this._items == null) {
            this._items = new HashSet<DiscoveryItems>();
        }
        return this._items;
    }

    public Map<TransformDescriptor, HubSeedDescriptor> getDuplicateTransforms() {
        if (this._duplicateTransforms == null) {
            this._duplicateTransforms = new HashMap<TransformDescriptor, HubSeedDescriptor>();
        }
        return this._duplicateTransforms;
    }

    public boolean isFailed() {
        return this._isFailed;
    }

    public void setFailed() {
        this._isFailed = true;
    }
}

