/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.transform.api.TransformMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class TransformMessageCache {
    public static final boolean ENABLED = false;
    private static final String PREF_MSG_LIFETIME = "maltego.msg.lifetime";
    private static final TransformMessageCache INSTANCE = new TransformMessageCache();
    private final Map<GraphID, GraphMessages> messages = new HashMap<GraphID, GraphMessages>();
    private Integer msgLifetime;

    public static TransformMessageCache getInstance() {
        return INSTANCE;
    }

    public Map<GraphID, GraphMessages> getMessages() {
        return this.messages;
    }

    public int getMessageLifetimeMillis() {
        if (this.msgLifetime == null) {
            this.msgLifetime = this.getPrefs().getInt(PREF_MSG_LIFETIME, 60000);
        }
        return this.msgLifetime;
    }

    public void setMessageLifetimeMillis(int millis) {
        this.getPrefs().putInt(PREF_MSG_LIFETIME, millis);
        this.msgLifetime = millis;
    }

    private Preferences getPrefs() {
        return NbPreferences.forModule(this.getClass());
    }

    public static class GraphMessages
    extends HashMap<EntityID, List<TransformMessage>> {
    }
}

