/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion;

import groovy.lang.MetaMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionHandler2;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.Documentation;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.completion.GroovyCompletionResult;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionContext;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.completion.provider.GroovyCompletionImpl;
import org.netbeans.modules.groovy.editor.utils.GroovyUtils;
import org.openide.util.Lookup;

public class CompletionHandler
implements CodeCompletionHandler2 {
    private static final Logger LOG = Logger.getLogger(CompletionHandler.class.getName());
    private GroovyCompletionImpl impl;

    private GroovyCompletionImpl impl() {
        if (this.impl == null) {
            this.impl = (GroovyCompletionImpl)Lookup.getDefault().lookup(GroovyCompletionImpl.class);
            if (this.impl == null) {
                LOG.severe("Unable to find completion impl");
                this.impl = new GroovyCompletionImpl();
            }
        }
        return this.impl;
    }

    public CodeCompletionResult complete(CodeCompletionContext completionContext) {
        GroovyCompletionImpl.CompletionImplResult rs = this.impl().makeProposals(completionContext);
        if (rs == null) {
            return CodeCompletionResult.NONE;
        }
        if (rs.isEmpty()) {
            return new DefaultCompletionResult(Collections.emptyList(), false);
        }
        return new GroovyCompletionResult(rs.getProposals(), rs.getGroovyContext());
    }

    boolean checkForPackageStatement(CompletionContext request) {
        TokenSequence<GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence((Document)request.doc, 1);
        if (ts != null) {
            ts.move(1);
            while (ts.isValid() && ts.moveNext() && ts.offset() < request.doc.getLength()) {
                Token t = ts.token();
                if (t.id() != GroovyTokenId.LITERAL_package) continue;
                return true;
            }
        }
        return false;
    }

    private ArgumentListExpression getSurroundingArgumentList(AstPath path) {
        if (path == null) {
            LOG.log(Level.FINEST, "path == null");
            return null;
        }
        LOG.log(Level.FINEST, "AEL, Path : {0}", path);
        for (ASTNode current : path) {
            if (!(current instanceof ArgumentListExpression)) continue;
            return (ArgumentListExpression)current;
        }
        return null;
    }

    private AstPath getPathFromInfo(int caretOffset, ParserResult info) {
        assert (info != null);
        ModuleNode root = ASTUtils.getRoot(info);
        if (root == null) {
            return null;
        }
        BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(true);
        return new AstPath((ASTNode)root, caretOffset, doc);
    }

    boolean checkBehindDot(CompletionContext request) {
        boolean behindDot = false;
        if (request == null || request.context == null || request.context.before1 == null) {
            behindDot = false;
        } else if (CharSequenceUtilities.textEquals((CharSequence)request.context.before1.text(), (CharSequence)".") || request.context.before1.text().toString().equals(request.getPrefix()) && request.context.before2 != null && CharSequenceUtilities.textEquals((CharSequence)request.context.before2.text(), (CharSequence)".")) {
            behindDot = true;
        }
        return behindDot;
    }

    public static String getMethodSignature(MetaMethod method, boolean forURL, boolean isGDK) {
        String methodSignature = method.getSignature();
        methodSignature = methodSignature.trim();
        if (isGDK) {
            int firstSpace = methodSignature.indexOf(" ");
            if (firstSpace != -1) {
                methodSignature = methodSignature.substring(firstSpace + 1);
            }
            if (forURL) {
                methodSignature = methodSignature.replaceAll(", ", ",%20");
            }
            return methodSignature;
        }
        String[] parts = methodSignature.split("[()]");
        if (parts.length < 2) {
            return "";
        }
        String paramsBody = CompletionHandler.decodeTypes(parts[1], forURL);
        return parts[0] + "(" + paramsBody + ")";
    }

    static String decodeTypes(String encodedType, boolean forURL) {
        String DELIMITER = ",";
        DELIMITER = forURL ? DELIMITER + "%20" : DELIMITER + " ";
        StringBuilder sb = new StringBuilder("");
        boolean nextIsAnArray = false;
        for (int i = 0; i < encodedType.length(); ++i) {
            char c = encodedType.charAt(i);
            if (c == '[') {
                nextIsAnArray = true;
                continue;
            }
            if (c == 'Z') {
                sb.append("boolean");
            } else if (c == 'B') {
                sb.append("byte");
            } else if (c == 'C') {
                sb.append("char");
            } else if (c == 'D') {
                sb.append("double");
            } else if (c == 'F') {
                sb.append("float");
            } else if (c == 'I') {
                sb.append("int");
            } else if (c == 'J') {
                sb.append("long");
            } else if (c == 'S') {
                sb.append("short");
            } else if (c == 'L') {
                int semicolon = encodedType.indexOf(";", ++i);
                String typeName = encodedType.substring(i, semicolon);
                typeName = typeName.replace('/', '.');
                if (forURL) {
                    sb.append(typeName);
                } else {
                    sb.append(GroovyUtils.stripPackage(typeName));
                }
                i = semicolon;
            }
            if (nextIsAnArray) {
                sb.append("[]");
                nextIsAnArray = false;
            }
            if (i >= encodedType.length() - 1) continue;
            sb.append(DELIMITER);
        }
        return sb.toString();
    }

    public String document(ParserResult info, ElementHandle element) {
        return this.impl().document(info, element);
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return originalHandle;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        char c = typedText.charAt(0);
        if (c == '.') {
            return CodeCompletionHandler.QueryType.COMPLETION;
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document d, int selectionBegin, int selectionEnd) {
        return Collections.emptySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        LOG.log(Level.FINEST, "parameters(), caretOffset = {0}", caretOffset);
        ArrayList<String> paramList = new ArrayList<String>();
        AstPath path = this.getPathFromInfo(caretOffset, info);
        BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(true);
        if (path != null) {
            ArgumentListExpression ael = this.getSurroundingArgumentList(path);
            if (ael != null) {
                List<ASTNode> children = ASTUtils.children((ASTNode)ael);
                int idx = 1;
                int index = -1;
                int offset = -1;
                for (ASTNode node : children) {
                    OffsetRange range = ASTUtils.getRange(node, doc);
                    paramList.add(node.getText());
                    if (range.containsInclusive(caretOffset)) {
                        offset = range.getStart();
                        index = idx;
                    }
                    ++idx;
                }
                if (paramList == null || paramList.isEmpty()) return ParameterInfo.NONE;
                return new ParameterInfo(paramList, index, offset);
            }
            LOG.log(Level.FINEST, "ArgumentListExpression ==  null");
            return ParameterInfo.NONE;
        }
        LOG.log(Level.FINEST, "path ==  null");
        return ParameterInfo.NONE;
    }

    public Documentation documentElement(ParserResult info, ElementHandle handle, Callable<Boolean> cancel) {
        return this.impl().documentElement(info, handle, cancel);
    }
}

