/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.typing.editing.controls.AttachPanel;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.File;
import java.util.List;
import org.openide.WizardDescriptor;

public class AttachPanelController
extends ValidatingController<AttachPanel> {
    public static final Object SOURCE_FILES = new Object();
    public static final Object SOURCE_URLS = new Object();
    public static final String PROP_SOURCE = "attachSource";
    public static final String PROP_FILES = "sourceFiles";
    public static final String PROP_URLS = "sourceURLs";

    protected AttachPanel createComponent() {
        AttachPanel panel = new AttachPanel();
        panel.addChangeListener(this.changeListener());
        return panel;
    }

    protected String getFirstError(AttachPanel component) {
        String error = null;
        if (((AttachPanel)this.component()).getSource() == 0) {
            List<File> files = ((AttachPanel)this.component()).getFiles();
            if (files == null || files.isEmpty()) {
                error = "Please enter a file path.";
            } else {
                for (File file : files) {
                    if (file.isDirectory()) {
                        error = "The following path is a directory: " + file;
                    } else if (!file.exists()) {
                        error = "The file does not exist: " + file;
                    } else {
                        if (file.canRead()) continue;
                        error = "The file is not readable: " + file;
                    }
                    break;
                }
            }
        } else {
            List<FastURL> urls = ((AttachPanel)this.component()).getURLs();
            if (urls == null || urls.isEmpty()) {
                error = "Please enter a URL.";
            }
        }
        return error;
    }

    protected void readSettings(WizardDescriptor settings) {
        List urls = (List)settings.getProperty(PROP_URLS);
        ((AttachPanel)this.component()).setURLs(urls);
        List files = (List)settings.getProperty(PROP_FILES);
        ((AttachPanel)this.component()).setFiles(files);
        Object source = settings.getProperty(PROP_SOURCE);
        if (SOURCE_URLS.equals(source)) {
            ((AttachPanel)this.component()).setSource(1);
        } else {
            ((AttachPanel)this.component()).setSource(0);
        }
    }

    protected void storeSettings(WizardDescriptor settings) {
        List<File> files = ((AttachPanel)this.component()).getFiles();
        settings.putProperty(PROP_FILES, files);
        List<FastURL> urls = ((AttachPanel)this.component()).getURLs();
        settings.putProperty(PROP_URLS, urls);
        boolean isURLSource = ((AttachPanel)this.component()).getSource() == 1;
        settings.putProperty(PROP_SOURCE, isURLSource ? SOURCE_URLS : SOURCE_FILES);
    }
}

