/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.labels;

import com.bulenkov.iconloader.util.GraphicsUtil;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.NodeLabelUtils;
import com.paterva.maltego.ui.graph.view2d.RoundRectHotSpotPainter;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabel;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabelDescriptor;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;
import yguard.A.J.BA;

class EntityPropertyLabelTranslator {
    EntityPropertyLabelTranslator() {
    }

    public EntityPropertyLabel translate(EntityPropertyLabelDescriptor descriptor) {
        String descriptorColor;
        EntityPropertyLabel label = new EntityPropertyLabel(descriptor.getProperty()){

            protected void paintContent(Graphics2D g2D, double x2, double y2, double width, double height) {
                BA nr = this.getRealizer();
                if (!CollectionNodeUtils.isCollectionNode(nr)) {
                    String text = this.getText();
                    if (nr.isSelected() && text != null && !text.isEmpty()) {
                        GraphicsUtil.setupTextAntialiasing((Graphics)g2D, null);
                        g2D.setColor(this.getTextColor());
                        g2D.setFont(this.getFont());
                        double zoom = GraphicsUtils.getZoom((Graphics2D)g2D);
                        float strokeWidth = RoundRectHotSpotPainter.getStrokeWidth();
                        if (zoom < 1.0) {
                            strokeWidth = (float)((double)strokeWidth / zoom);
                        }
                        Rectangle2D rect = NodeLabelUtils.getRectangle2D(nr, strokeWidth * 2.0f);
                        GraphicsUtils.drawStringAroundCirle((Graphics2D)g2D, (String)text, (Rectangle2D)rect, (double)strokeWidth, (boolean)true);
                    } else {
                        super.paintContent(g2D, x2, y2 - 15.0, width, height);
                    }
                }
            }
        };
        label.setModel(this.translateModel(descriptor.getModel()));
        label.setPosition(this.translatePosition(descriptor.getPosition()));
        String descriptorFont = descriptor.getFont();
        if (descriptorFont != null) {
            Font font = UIManager.getLookAndFeelDefaults().getFont(descriptorFont);
            if (font == null) {
                font = Font.decode(descriptorFont);
            }
            label.setFont(font);
        }
        if ((descriptorColor = descriptor.getColor()) != null) {
            Color color = UIManager.getLookAndFeelDefaults().getColor(descriptorColor);
            if (color == null) {
                color = Color.decode(descriptorColor);
            }
            label.setTextColor(color);
        }
        return label;
    }

    private byte translateModel(String model) {
        if ("EightPos".equals(model)) {
            return 5;
        }
        if ("Internal".equals(model)) {
            return 1;
        }
        throw new IllegalArgumentException("Unknown entity label model: " + model);
    }

    private byte translatePosition(String position) {
        if ("N".equals(position)) {
            return 108;
        }
        if ("NE".equals(position)) {
            return 105;
        }
        if ("E".equals(position)) {
            return 110;
        }
        if ("SE".equals(position)) {
            return 106;
        }
        if ("S".equals(position)) {
            return 109;
        }
        if ("SW".equals(position)) {
            return 107;
        }
        if ("W".equals(position)) {
            return 111;
        }
        if ("NW".equals(position)) {
            return 104;
        }
        if ("Top".equals(position)) {
            return 102;
        }
        if ("TopRight".equals(position)) {
            return 118;
        }
        if ("Right".equals(position)) {
            return 116;
        }
        if ("BottomRight".equals(position)) {
            return 120;
        }
        if ("Bottom".equals(position)) {
            return 101;
        }
        if ("BottomLeft".equals(position)) {
            return 119;
        }
        if ("Left".equals(position)) {
            return 115;
        }
        if ("TopLeft".equals(position)) {
            return 117;
        }
        throw new IllegalArgumentException("Unknown entity label position: " + position);
    }
}

