/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.clipboard.MouseLocationGraphPasteAction;
import com.paterva.maltego.ui.graph.merge.InteractiveGraphMerger;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import java.util.Set;

public class MergeGraphPasteAction
extends MouseLocationGraphPasteAction {
    private InteractiveGraphMerger _interactiveMerger;

    public String getName() {
        return "Paste";
    }

    @Override
    protected void prePasteGraph(GraphID targetGraphID, GraphID graphToPasteID) {
        super.prePasteGraph(targetGraphID, graphToPasteID);
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphToPasteID);
        String entityDescription = GraphTransactionHelper.getDescriptionForEntitiesItr(targetGraphID, (Iterable<MaltegoEntity>)entities, true);
        String description = "%s " + entityDescription;
        SimilarStrings descriptions = new SimilarStrings(description, "Paste", "Delete/unmerge");
        this._interactiveMerger = new InteractiveGraphMerger(targetGraphID, graphToPasteID, descriptions);
        this._interactiveMerger.promptMergeGraphs();
    }

    @Override
    protected void pasteGraph(GraphID targetGraphID, GraphID graphToPasteID) throws GraphStoreException {
        this._interactiveMerger.mergeGraphs();
    }

    @Override
    protected void postPasteGraph(GraphID targetGraphID, GraphID graphToPasteID) {
        this._interactiveMerger.selectSourceNodes();
    }
}

