/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;

public final class ZeroBasedDoubleArray
extends AbstractDoubleArray {
    private static final ZeroBasedDoubleArray ZERO_BASED_DOUBLE_ARRAY = new ZeroBasedDoubleArray(0, ZeroBasedDoubleArray.createCache());

    public static ZeroBasedDoubleArray makeZeroBasedDoubleArray(DynamicObject object, int length, int usedLength, double[] array, int integrityLevel) {
        ZeroBasedDoubleArray arrayType = (ZeroBasedDoubleArray)ZeroBasedDoubleArray.createZeroBasedDoubleArray().setIntegrityLevel(integrityLevel);
        JSAbstractArray.arraySetLength(object, length);
        JSAbstractArray.arraySetUsedLength(object, usedLength);
        JSAbstractArray.arraySetArray(object, array);
        return arrayType;
    }

    public static ZeroBasedDoubleArray createZeroBasedDoubleArray() {
        return ZERO_BASED_DOUBLE_ARRAY;
    }

    private ZeroBasedDoubleArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    public double getInBoundsFastDouble(DynamicObject object, int index) {
        return ZeroBasedDoubleArray.getArray(object)[index];
    }

    @Override
    public void setInBoundsFast(DynamicObject object, int index, double value) {
        ZeroBasedDoubleArray.getArray((DynamicObject)object)[index] = value;
    }

    @Override
    public boolean isSupported(DynamicObject object, long index) {
        return ZeroBasedDoubleArray.isSupportedZeroBased(object, (int)index);
    }

    @Override
    protected int prepareInBoundsFast(DynamicObject object, long index) {
        return (int)index;
    }

    @Override
    protected int prepareInBounds(DynamicObject object, int index, ScriptArray.ProfileHolder profile) {
        ZeroBasedDoubleArray.prepareInBoundsZeroBased(object, index, profile);
        return index;
    }

    @Override
    protected int prepareSupported(DynamicObject object, int index, ScriptArray.ProfileHolder profile) {
        this.prepareSupportedZeroBased(object, index, profile);
        return index;
    }

    @Override
    protected void setLengthLess(DynamicObject object, long length, ScriptArray.ProfileHolder profile) {
        this.setLengthLessZeroBased(object, length, profile);
    }

    @Override
    public ZeroBasedObjectArray toObject(DynamicObject object, long index, Object value) {
        double[] array = ZeroBasedDoubleArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        Object[] doubleCopy = ArrayCopy.doubleToObject(array, 0, usedLength);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, length, usedLength, doubleCopy, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedDoubleArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ContiguousDoubleArray toContiguous(DynamicObject object, long index, Object value) {
        double[] array = ZeroBasedDoubleArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        ContiguousDoubleArray newArray = ContiguousDoubleArray.makeContiguousDoubleArray(object, length, array, 0L, 0, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedDoubleArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public HolesDoubleArray toHoles(DynamicObject object, long index, Object value) {
        double[] array = ZeroBasedDoubleArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        HolesDoubleArray newArray = HolesDoubleArray.makeHolesDoubleArray(object, length, array, 0L, 0, usedLength, 0, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedDoubleArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public long firstElementIndex(DynamicObject object) {
        return 0L;
    }

    @Override
    public long lastElementIndex(DynamicObject object) {
        return ZeroBasedDoubleArray.getUsedLength(object) - 1;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        double[] array = ZeroBasedDoubleArray.getArray(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        long moveLength = (long)usedLength - end;
        if (moveLength > 0L) {
            System.arraycopy(array, (int)end, array, (int)start, (int)moveLength);
        }
        return this;
    }

    @Override
    public ScriptArray shiftRangeImpl(DynamicObject object, long from) {
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        if (from < (long)usedLength) {
            return ContiguousDoubleArray.makeContiguousDoubleArray(object, (long)this.lengthInt(object) - from, ZeroBasedDoubleArray.getArray(object), -from, (int)from, (int)((long)usedLength - from), this.integrityLevel);
        }
        return this.removeRangeImpl(object, 0L, from);
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        return this.addRangeImplZeroBased(object, offset, size);
    }

    @Override
    public boolean hasHoles(DynamicObject object) {
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        return usedLength < length;
    }

    @Override
    protected ZeroBasedDoubleArray withIntegrityLevel(int newIntegrityLevel) {
        return new ZeroBasedDoubleArray(newIntegrityLevel, this.cache);
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index) {
        return this.nextElementIndexZeroBased(object, index);
    }
}

