/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.List;

public final class HolesObjectArray
extends AbstractContiguousObjectArray {
    private static final HolesObjectArray HOLES_OBJECT_ARRAY = new HolesObjectArray(0, HolesObjectArray.createCache());

    private HolesObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    public static HolesObjectArray makeHolesObjectArray(DynamicObject object, int length, Object[] array, long indexOffset, int arrayOffset, int usedLength, int holeCount, int integrityLevel) {
        HolesObjectArray arrayType = (HolesObjectArray)HolesObjectArray.createHolesObjectArray().setIntegrityLevel(integrityLevel);
        HolesObjectArray.setArrayProperties(object, array, length, usedLength, indexOffset, arrayOffset);
        JSAbstractArray.arraySetHoleCount(object, holeCount);
        assert (arrayType.assertHoleCount(object));
        return arrayType;
    }

    public static HolesObjectArray createHolesObjectArray() {
        return HOLES_OBJECT_ARRAY;
    }

    @Override
    AbstractWritableArray sameTypeHolesArray(DynamicObject object, int length, Object array, long indexOffset, int arrayOffset, int usedLength, int holeCount) {
        HolesObjectArray.setArrayProperties(object, array, length, usedLength, indexOffset, arrayOffset);
        JSAbstractArray.arraySetHoleCount(object, holeCount);
        return this;
    }

    @Override
    public void setInBoundsFast(DynamicObject object, int index, Object value) {
        throw Errors.shouldNotReachHere("should not call this method, use setInBounds(Non)Hole");
    }

    public boolean isHoleFast(DynamicObject object, int index) {
        int internalIndex = (int)((long)index - this.getIndexOffset(object));
        return this.isHolePrepared(object, internalIndex);
    }

    public void setInBoundsFastHole(DynamicObject object, int index, Object value) {
        int internalIndex = (int)((long)index - this.getIndexOffset(object));
        assert (this.isHolePrepared(object, internalIndex));
        this.incrementHolesCount(object, -1);
        this.setInBoundsFastIntl(object, index, internalIndex, value);
    }

    public void setInBoundsFastNonHole(DynamicObject object, int index, Object value) {
        int internalIndex = (int)((long)index - this.getIndexOffset(object));
        assert (!this.isHolePrepared(object, internalIndex));
        this.setInBoundsFastIntl(object, index, internalIndex, HolesObjectArray.checkNonNull(value));
    }

    private void setInBoundsFastIntl(DynamicObject object, int index, int internalIndex, Object value) {
        HolesObjectArray.getArray((DynamicObject)object)[internalIndex] = value;
    }

    @Override
    public boolean containsHoles(DynamicObject object, long index) {
        return JSAbstractArray.arrayGetHoleCount(object) > 0 || !this.isInBoundsFast(object, index);
    }

    @Override
    public AbstractObjectArray toNonHoles(DynamicObject object, long index, Object value) {
        assert (!this.containsHoles(object, index));
        Object[] array = HolesObjectArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = HolesObjectArray.getUsedLength(object);
        int arrayOffset = this.getArrayOffset(object);
        long indexOffset = this.getIndexOffset(object);
        this.setInBoundsFastNonHole(object, (int)index, value);
        AbstractObjectArray newArray = indexOffset == 0L && arrayOffset == 0 ? ZeroBasedObjectArray.makeZeroBasedObjectArray(object, length, usedLength, array, this.integrityLevel) : ContiguousObjectArray.makeContiguousObjectArray(object, length, array, indexOffset, arrayOffset, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            HolesObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public int prepareInBounds(DynamicObject object, int index, ScriptArray.ProfileHolder profile) {
        return this.prepareInBoundsHoles(object, index, profile);
    }

    @Override
    public boolean isSupported(DynamicObject object, long index) {
        return this.isSupportedHoles(object, index);
    }

    @Override
    public int prepareSupported(DynamicObject object, int index, ScriptArray.ProfileHolder profile) {
        return this.prepareSupportedHoles(object, index, profile);
    }

    @Override
    public Object getInBoundsFast(DynamicObject object, int index) {
        Object value = this.getInBoundsFastObject(object, index);
        if (HolesObjectArray.isHoleValue(value)) {
            return Undefined.instance;
        }
        return value;
    }

    @Override
    public HolesObjectArray toHoles(DynamicObject object, long index, Object value) {
        return this;
    }

    public static boolean isHoleValue(Object value) {
        return value == null;
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index0) {
        return this.nextElementIndexHoles(object, index0);
    }

    @Override
    public long previousElementIndex(DynamicObject object, long index0) {
        return this.previousElementIndexHoles(object, index0);
    }

    @Override
    public boolean hasElement(DynamicObject object, long index) {
        return super.hasElement(object, index) && !this.isHolePrepared(object, this.prepareInBoundsFast(object, (int)index));
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict) {
        return this.deleteElementHoles(object, index);
    }

    @Override
    public boolean isHolesType() {
        return true;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        return this.removeRangeHoles(object, start, end);
    }

    @Override
    protected Object castNonNull(Object value) {
        return value;
    }

    @Override
    protected HolesObjectArray withIntegrityLevel(int newIntegrityLevel) {
        return new HolesObjectArray(newIntegrityLevel, this.cache);
    }

    @Override
    public List<Object> ownPropertyKeys(DynamicObject object) {
        return this.ownPropertyKeysHoles(object);
    }
}

