/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.Set;

@ImportStatic(value={JSConfig.class})
public abstract class IteratorValueNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    protected JavaScriptNode iterResultNode;
    @Node.Child
    private PropertyGetNode getValueNode;

    protected IteratorValueNode(JSContext context, JavaScriptNode iterResultNode) {
        this.iterResultNode = iterResultNode;
        this.getValueNode = PropertyGetNode.create("value", false, context);
    }

    public static IteratorValueNode create(JSContext context) {
        return IteratorValueNode.create(context, null);
    }

    public static IteratorValueNode create(JSContext context, JavaScriptNode iterResult) {
        return IteratorValueNodeGen.create(context, iterResult);
    }

    @Specialization
    protected Object doIteratorNext(DynamicObject iterResult) {
        return this.getValueNode.getValue(iterResult);
    }

    @Specialization(guards={"isForeignObject(obj)"}, limit="InteropLibraryLimit")
    protected Object doForeignObject(Object obj, @CachedLibrary(value="obj") InteropLibrary interop) {
        try {
            return interop.readMember(obj, "value");
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "value", this);
        }
    }

    public abstract Object execute(Object var1);

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return IteratorValueNodeGen.create(this.getValueNode.getContext(), IteratorValueNode.cloneUninitialized(this.iterResultNode, materializedTags));
    }
}

