/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.ui;

import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.reconnect.ReconnectController;
import com.paterva.maltego.chatapi.reconnect.ReconnectState;
import com.paterva.maltego.collab.graph.GraphChatRoom;
import com.paterva.maltego.collab.ui.ReconnectCallback;
import com.paterva.maltego.collab.ui.ReconnectControllers;
import com.paterva.maltego.collab.ui.ReconnectProgressPanel;
import com.paterva.maltego.collab.ui.ReconnectWaitPanel;
import com.paterva.maltego.ui.graph.view2d.controls.GraphAddOnControls;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.openide.util.Cancellable;

public class ReconnectAddOnDisplayer
implements PropertyChangeListener {
    private GraphChatRoom _chatRoom;
    private ReconnectController _controller;
    private ReconnectProgressPanel _progressPanel;
    private ReconnectWaitPanel _waitPanel;
    private TryReconnectCallback _reconnectCallback = new TryReconnectCallback();

    public ReconnectAddOnDisplayer(GraphChatRoom chatRoom) {
        this._chatRoom = chatRoom;
        this._controller = ReconnectControllers.get((ChatRoom)chatRoom);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ReconnectAddOnDisplayer.this.propertyChangeImpl(evt);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void propertyChangeImpl(PropertyChangeEvent evt) {
        if ("reconnectStateChanged".equals(evt.getPropertyName())) {
            this.stateChanged((ReconnectState)evt.getNewValue());
        } else if ("reconnectDescriptionChanged".equals(evt.getPropertyName())) {
            this.descriptionChanged((String)evt.getNewValue());
        } else if ("reconnectProgressTextChanged".equals(evt.getPropertyName())) {
            this.progressTextChanged((String)evt.getNewValue());
        } else if ("reconnectProgressChanged".equals(evt.getPropertyName())) {
            this.progressChanged((Integer)evt.getNewValue());
        } else if ("reconnectWaitTimeChanged".equals(evt.getPropertyName())) {
            this.waitTimeChanged((Integer)evt.getNewValue());
        }
    }

    private void stateChanged(ReconnectState state) {
        if (state != ReconnectState.RECONNECTING) {
            this.removeProgressPanel();
        }
        if (state != ReconnectState.WAITING) {
            this.removeWaitingPanel();
        }
        if (state == ReconnectState.RECONNECTING) {
            if (this._progressPanel == null) {
                this._progressPanel = new ReconnectProgressPanel((Cancellable)this._controller);
                this._progressPanel.setDescription(this._controller.getReconnectProgress().getDescription());
                this._progressPanel.setProgressText(this._controller.getReconnectProgress().getProgressText());
                this._progressPanel.setProgress(this._controller.getReconnectProgress().getProgress());
                GraphAddOnControls.getDefault().add(this._chatRoom.getGraphDataObject(), (Component)this._progressPanel);
            }
        } else if (state == ReconnectState.WAITING && this._waitPanel == null) {
            this._waitPanel = new ReconnectWaitPanel(this._reconnectCallback, (Cancellable)this._controller);
            this._waitPanel.setDescription(this.getWaitDescription(this._controller.getReconnectProgress().getWaitSeconds()));
            GraphAddOnControls.getDefault().add(this._chatRoom.getGraphDataObject(), (Component)this._waitPanel);
        }
    }

    private void removeProgressPanel() {
        if (this._progressPanel != null) {
            GraphAddOnControls.getDefault().remove(this._chatRoom.getGraphDataObject(), (Component)this._progressPanel);
            this._progressPanel = null;
        }
    }

    private void removeWaitingPanel() {
        if (this._waitPanel != null) {
            GraphAddOnControls.getDefault().remove(this._chatRoom.getGraphDataObject(), (Component)this._waitPanel);
            this._waitPanel = null;
        }
    }

    private void descriptionChanged(String description) {
        if (this._progressPanel != null) {
            this._progressPanel.setDescription(description);
        }
    }

    private void progressTextChanged(String text) {
        if (this._progressPanel != null) {
            this._progressPanel.setProgressText(text);
        }
    }

    private void progressChanged(Integer progress) {
        if (this._progressPanel != null) {
            this._progressPanel.setProgress(progress);
        }
    }

    private void waitTimeChanged(int waitSeconds) {
        if (this._waitPanel != null) {
            this._waitPanel.setDescription(this.getWaitDescription(waitSeconds));
        }
    }

    private String getWaitDescription(int waitTime) {
        return String.format("Waiting to reconnect (%d seconds)...", waitTime);
    }

    private class TryReconnectCallback
    implements ReconnectCallback {
        private TryReconnectCallback() {
        }

        @Override
        public void reconnect() {
            ReconnectAddOnDisplayer.this._controller.start();
        }
    }
}

