/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.conn.ConnectionStatus;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.ParticipantEvent;
import com.paterva.maltego.collab.ParticipantPresence;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.RxHandler;
import com.paterva.maltego.collab.TxHandler;
import com.paterva.maltego.collab.graph.GraphProvider;
import com.paterva.maltego.collab.graph.state.AbstractState;
import com.paterva.maltego.collab.graph.state.ConnectionController;
import com.paterva.maltego.collab.graph.state.HistoryEndMessage;
import com.paterva.maltego.collab.graph.state.ParticipantPool;
import com.paterva.maltego.collab.graph.state.RequestGraphMessage;
import com.paterva.maltego.collab.graph.state.RxQueue;
import com.paterva.maltego.collab.graph.state.SignalMessage;
import com.paterva.maltego.collab.graph.state.StateDisconnecting;
import com.paterva.maltego.collab.graph.state.TxQueue;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.SessionID;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AbstractConnectionState
extends AbstractState<ConnectionController>
implements TxHandler,
RxHandler {
    private final ConnectionStatus _status;

    public AbstractConnectionState(ConnectionStatus status, boolean isEndState) {
        super(isEndState);
        this._status = status;
    }

    protected RxHandler rx() {
        return ((ConnectionController)this.getStateMachine()).getRxHandler();
    }

    protected TxHandler tx() {
        return ((ConnectionController)this.getStateMachine()).getTxHandler();
    }

    protected TxQueue localQueue() {
        return ((ConnectionController)this.getStateMachine()).getLocalQueue();
    }

    protected RxQueue liveQueue() {
        return ((ConnectionController)this.getStateMachine()).getLiveQueue();
    }

    protected RxQueue historyQueue() {
        return ((ConnectionController)this.getStateMachine()).getHistoryQueue();
    }

    protected String lastAppliedTransactionID() {
        return ((ConnectionController)this.getStateMachine()).getLastAppliedTransactionID();
    }

    protected ParticipantPool participants() {
        return ((ConnectionController)this.getStateMachine()).getParticipants();
    }

    protected GraphProvider graphProvider() {
        return ((ConnectionController)this.getStateMachine()).getGraphProvider();
    }

    protected boolean isReconnect() {
        return ((ConnectionController)this.getStateMachine()).isReconnect();
    }

    protected CollaborationSessionInfo sessionInfo() {
        return ((ConnectionController)this.getStateMachine()).getSessionInfo();
    }

    protected Participant me() {
        return ((ConnectionController)this.getStateMachine()).getMe();
    }

    protected ConnectionStatus getConnectionStatus() {
        return this._status;
    }

    protected AbstractState getErrorState() {
        return ((ConnectionController)this.getStateMachine()).getInitialState();
    }

    protected void sleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void sessionDropped(Exception e) {
        this.debug("Session dropped " + e);
        this.progress(LogMessageLevel.Warning, "Session dropped");
        if (e != null) {
            this.handleError("Session dropped", e);
        } else {
            this.setNextState(new StateDisconnecting());
        }
    }

    void sessionIDChanged(SessionID id) {
    }

    protected void handleError(String message, Exception e) {
        StringBuilder buffer = new StringBuilder();
        if (message != null) {
            buffer.append(message);
        }
        if (buffer.length() > 0) {
            buffer.append(": ");
        }
        buffer.append(e.getMessage());
        String msg = buffer.toString();
        this.debug(msg);
        this.progress(LogMessageLevel.Error, msg);
        this.handleError(e, new StateDisconnecting());
    }

    @Override
    public void participantEventReceived(ParticipantEvent event) throws CollaborationException {
        this.rx().participantEventReceived(event);
    }

    @Override
    public void showMessage(LogMessageLevel level, String message) {
        this.rx().showMessage(level, message);
    }

    @Override
    public void sendPayload(String to, String xml) throws CollaborationException {
        this.illegalState();
    }

    @Override
    public void updateStatus(ParticipantPresence presence, String message) throws CollaborationException {
        this.illegalState();
    }

    @Override
    public void payloadsReceived(PayloadCollection payloads) throws CollaborationException {
        this.illegalState();
    }

    protected void illegalState() {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, String.format("Nothing should happen in the %s state", this.getClass().getSimpleName()));
    }

    static {
        SignalMessage.register("getgraph", RequestGraphMessage.class);
        SignalMessage.register("history-done", HistoryEndMessage.class);
    }
}

