/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporterFactory;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.ui.wizard.SampleHeaderRenderer;
import com.paterva.maltego.util.ui.table.ColumnSelectionTable;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openide.util.WeakListeners;

public abstract class SampleTableModel
extends AbstractTableModel {
    public static final String PROP_SELECTION_CHANGED = "selectionChanged";
    private static final int MAX_ROW_COUNT = 10;
    private TabularGraph _tabularGraph;
    private List<List<Object>> _sampleData;
    private TabularGraphListener _graphListener;
    private CustomizedSelectionTable _table;
    private Queue<Integer> _selection;
    private boolean _updatingTabularGraph = false;

    protected abstract Object getHeaderValue(int var1);

    public void setTabularGraphAndSampleFile(TabularGraph tabularGraph, File file) throws IOException {
        if (tabularGraph == null) {
            throw new IllegalArgumentException("tabularGraph may not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file may not be null");
        }
        this._tabularGraph = tabularGraph;
        this._graphListener = new TabularGraphListener();
        this._tabularGraph.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._graphListener, (Object)this._tabularGraph));
        this.loadSampleData(file);
        this.createColumns();
        this.updateColumnNames();
        this.updateTableHeaders();
    }

    public TabularGraph getTabularGraph() {
        return this._tabularGraph;
    }

    public JTable getTable() {
        if (this._table == null) {
            this._table = new CustomizedSelectionTable();
            this._table.setAutoCreateColumnsFromModel(false);
            this._table.setModel(this);
            this._table.setColumnSelectionAllowed(true);
            this._table.setRowSelectionAllowed(false);
            this._table.getTableHeader().setReorderingAllowed(false);
            this._table.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new SampleHeaderRenderer()));
            this._table.setFillsViewportHeight(true);
        }
        return this._table;
    }

    public void select(int[] columns) {
        this._table.select(columns);
        ListSelectionModel selectionModel = this._table.getColumnModel().getSelectionModel();
        int minColumn = selectionModel.getMinSelectionIndex();
        int maxColumn = selectionModel.getMaxSelectionIndex();
        Rectangle minRect = this._table.getCellRect(0, minColumn, true);
        Rectangle maxRect = this._table.getCellRect(0, maxColumn, true);
        this._table.scrollRectToVisible(minRect.union(maxRect));
    }

    @Override
    public int getRowCount() {
        if (this._sampleData != null) {
            this._sampleData.size();
            return this._sampleData.size() - (this._tabularGraph.hasHeaderRow() ? 1 : 0) - (this._tabularGraph.hasTypeRow() ? 1 : 0);
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (this._tabularGraph != null) {
            return this._tabularGraph.getColumnCount();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._tabularGraph.hasHeaderRow() && this._tabularGraph.hasTypeRow()) {
            rowIndex += 2;
        } else if (this._tabularGraph.hasHeaderRow() || this._tabularGraph.hasTypeRow()) {
            ++rowIndex;
        }
        List<Object> row = this._sampleData.get(rowIndex);
        if (columnIndex < row.size()) {
            Object value = row.get(columnIndex);
            if (value instanceof Date) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
                return format.format((Date)value);
            }
            if (value != null) {
                return value;
            }
        }
        return "";
    }

    protected void loadSampleData(File file) throws IOException {
        this._sampleData = new ArrayList<List<Object>>();
        int columnCount = 0;
        TabularGraphFileImporter importer = (TabularGraphFileImporter)TabularGraphFileImporterFactory.createImporter((File)file).get();
        try (TabularGraphIterator itr = importer.open();){
            for (int i = 0; i < 10 && itr.hasNext(); ++i) {
                List row = itr.getRow(null);
                this._sampleData.add(row);
                columnCount = Math.max(columnCount, row.size());
                itr.next();
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        for (List<Object> row : this._sampleData) {
            while (row.size() < columnCount) {
                row.add(null);
            }
        }
        this._tabularGraph.setColumnCount(columnCount);
        this.fireTableDataChanged();
    }

    protected void createColumns() {
        for (int column = this._table.getColumnCount() - 1; column >= 0; --column) {
            this._table.removeColumn(this._table.getColumnModel().getColumn(column));
        }
        boolean fitColumns = this._tabularGraph.getColumnCount() < 7;
        this._table.setAutoResizeMode(fitColumns ? 4 : 0);
        for (int i = 0; i < this._tabularGraph.getColumnCount(); ++i) {
            TableColumn column = new TableColumn(i);
            column.setPreferredWidth(120);
            this._table.getColumnModel().addColumn(column);
        }
    }

    protected void updateColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Object columnName : this._sampleData.get(this._tabularGraph.getHeaderRowIndex())) {
            if (this._tabularGraph.hasHeaderRow()) {
                columnNames.add(columnName == null ? "" : columnName.toString());
                continue;
            }
            columnNames.add("Column" + (columnNames.size() + 1));
        }
        String[] names = columnNames.toArray(new String[columnNames.size()]);
        this._tabularGraph.setColumnNames(names);
    }

    protected void updateTableHeaders() {
        for (int column = 0; column < this.getTable().getColumnCount(); ++column) {
            TableColumn tableColumn = this.getTable().getColumnModel().getColumn(column);
            tableColumn.setHeaderValue(this.getHeaderValue(column));
        }
        this._table.getTableHeader().revalidate();
        this._table.getTableHeader().repaint();
    }

    protected String createHTMLHeader(String columnName, String propertyName) {
        StringBuilder html = new StringBuilder();
        html.append("<HTML><NOBR>");
        html.append(columnName);
        html.append("<BR>");
        html.append(propertyName);
        html.append("</NOBR></HTML>");
        return html.toString();
    }

    protected boolean isUpdatingTabularGraph() {
        return this._updatingTabularGraph;
    }

    protected void onTabularGraphChanged(PropertyChangeEvent evt) {
        if (this.isUpdatingTabularGraph()) {
            return;
        }
        if ("columnRemoved".equals(evt.getPropertyName())) {
            Integer column = (Integer)((Object[])evt.getOldValue())[1];
            if (this._table.isColumnSelected(column)) {
                this._table.changeSelection(0, column, true, false);
            }
        } else if ("hasHeaderRowChanged".equals(evt.getPropertyName())) {
            this.backupSelection();
            this.updateColumnNames();
            this.fireTableDataChanged();
            this.restoreSelection();
        }
    }

    protected void onColumnSelected(int column) {
    }

    protected void onColumnToggled(int[] previousSelectedColumns, int column, boolean isSelected) {
    }

    protected void backupSelection() {
        TableColumnModel columnModel = this._table.getColumnModel();
        ListSelectionModel selectionModel = columnModel.getSelectionModel();
        int anchor = selectionModel.getAnchorSelectionIndex();
        int lead = selectionModel.getLeadSelectionIndex();
        int[] selectedColumns = columnModel.getSelectedColumns();
        this._selection = new ArrayDeque<Integer>(selectedColumns.length + 2);
        this._selection.add(anchor);
        this._selection.add(lead);
        for (int column : selectedColumns) {
            this._selection.add(column);
        }
    }

    protected void restoreSelection() {
        TableColumnModel columnModel = this._table.getColumnModel();
        ListSelectionModel selectionModel = columnModel.getSelectionModel();
        int anchor = this._selection.remove();
        int lead = this._selection.remove();
        for (Integer column : this._selection) {
            selectionModel.addSelectionInterval(column, column);
        }
        selectionModel.setAnchorSelectionIndex(anchor);
        selectionModel.setLeadSelectionIndex(lead);
        this._selection = null;
    }

    protected class CustomizedSelectionTable
    extends ColumnSelectionTable {
        protected CustomizedSelectionTable() {
        }

        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            SampleTableModel.this._updatingTabularGraph = true;
            int[] previousSelectedColumns = this.getSelectedColumns();
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
            if (!toggle && !extend) {
                int[] selectedColumns = this.getSelectedColumns();
                if (selectedColumns.length == 1) {
                    SampleTableModel.this.onColumnSelected(selectedColumns[0]);
                }
            } else if (!extend) {
                SampleTableModel.this.onColumnToggled(previousSelectedColumns, columnIndex, this.isColumnSelected(columnIndex));
            }
            this.firePropertyChange(SampleTableModel.PROP_SELECTION_CHANGED, null, null);
            SampleTableModel.this._updatingTabularGraph = false;
        }

        public void select(int[] columns) {
            ListSelectionModel sm = this.getColumnModel().getSelectionModel();
            int anchor = sm.getAnchorSelectionIndex();
            sm.clearSelection();
            for (int column : columns) {
                sm.addSelectionInterval(column, column);
            }
            sm.setAnchorSelectionIndex(anchor);
            sm.setLeadSelectionIndex(-1);
            this.firePropertyChange(SampleTableModel.PROP_SELECTION_CHANGED, null, null);
        }
    }

    protected class TabularGraphListener
    implements PropertyChangeListener {
        protected TabularGraphListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SampleTableModel.this.onTabularGraphChanged(evt);
        }
    }
}

