/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.output;

import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.output.MessageChunk;
import com.paterva.maltego.util.output.MessageLinkAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.awt.HtmlBrowser;

public class FormatMessage {
    public static List<MessageChunk> highlightUrls(List<MessageChunk> chunks) {
        Pattern pattern = Pattern.compile("(?<=^|\\s+)((?:http[s]?://|www\\.)[-\\w\\.\\:/]+(?:/[^\\s]*)*)(?=\\s+|$)");
        ArrayList<MessageChunk> highlightedChunks = new ArrayList<MessageChunk>();
        for (MessageChunk chunk : chunks) {
            if (chunk.getLinkListener() != null) {
                highlightedChunks.add(chunk);
                continue;
            }
            String text = chunk.getText();
            Matcher matcher = pattern.matcher(text);
            int pos = 0;
            while (matcher.find()) {
                URL browseUrl;
                String normal = text.substring(pos, matcher.start());
                String urlStr = matcher.group(1);
                URL url = null;
                try {
                    String properUrlStr = urlStr;
                    if (properUrlStr.startsWith("www.")) {
                        properUrlStr = "http://" + properUrlStr;
                    }
                    url = new URL(properUrlStr);
                }
                catch (MalformedURLException properUrlStr) {
                    // empty catch block
                }
                if (url == null) {
                    normal = normal + urlStr;
                }
                if (!normal.isEmpty()) {
                    highlightedChunks.add(new MessageChunk(normal));
                }
                if ((browseUrl = url) != null) {
                    MessageLinkAdapter urlClickListener = new MessageLinkAdapter(){

                        @Override
                        public void linkAction() {
                            if (!FileUtilities.isRemoteFileURL(browseUrl)) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(browseUrl);
                            }
                        }
                    };
                    highlightedChunks.add(new MessageChunk(urlStr, urlClickListener));
                }
                pos = matcher.end();
            }
            String rest = text.substring(pos);
            if (rest.isEmpty()) continue;
            highlightedChunks.add(new MessageChunk(rest));
        }
        return highlightedChunks;
    }
}

