/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.types.Converter;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.ShapeCollection;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;

class DetailCompositeSpatialStrategy
extends CompositeSpatialStrategy {
    public DetailCompositeSpatialStrategy(String fieldName, RecursivePrefixTreeStrategy indexStrategy, SerializedDVStrategy geometryStrategy) {
        super(fieldName, indexStrategy, geometryStrategy);
    }

    public Field[] createIndexableFields(Shape shape) {
        ArrayList fields = new ArrayList();
        for (Shape innerShape : this.decomposeShape(shape)) {
            Collections.addAll(fields, this.getIndexStrategy().createIndexableFields(innerShape));
        }
        Collections.addAll(fields, this.getGeometryStrategy().createIndexableFields(shape));
        return fields.toArray(new Field[fields.size()]);
    }

    private ArrayList<Shape> decomposeShape(Shape shape) {
        ArrayList<Shape> list = new ArrayList<Shape>();
        this.addInnerShapes(shape, list);
        return list;
    }

    private void addInnerShapes(Shape shape, ArrayList<Shape> to) {
        block6: {
            block4: {
                List shapes;
                block5: {
                    if (!(shape instanceof ShapeCollection)) break block4;
                    shapes = ((ShapeCollection)shape).getShapes();
                    if (shapes.size() <= 1) break block5;
                    for (Object s : shapes) {
                        this.addInnerShapes((Shape)s, to);
                    }
                    break block6;
                }
                if (shapes.isEmpty()) break block6;
                to.add((Shape)shapes.get(0));
                break block6;
            }
            if (shape instanceof JtsGeometry) {
                Geometry geoGroup = ((JtsGeometry)shape).getGeom();
                GeometryCollectionIterator it = new GeometryCollectionIterator(geoGroup);
                Geometry prev = null;
                while (it.hasNext()) {
                    Geometry geo = (Geometry)it.next();
                    if (!(geo instanceof GeometryCollection) && geo != prev) {
                        to.add(this.toShape(geo));
                    }
                    prev = geo;
                }
            }
        }
    }

    private Shape toShape(Geometry value) {
        return new JtsGeometry((Geometry)value.clone(), Converter.getSpatialContext(), true, false);
    }
}

