/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphType;
import com.paterva.maltego.ui.graph.GraphTypeChangePropagator;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.view2d.labels.EntityPropertyLabelSettings;
import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.windows.TopComponent;

public class AdditionalLabelsPanel
extends JPanel
implements ItemListener {
    private JCheckBox _checkBoxShowLabels = null;

    public AdditionalLabelsPanel() {
        this.addComponents();
        GraphEditorRegistry.getDefault().addPropertyChangeListener(new GraphListener());
        GraphTypeChangePropagator.get().addChangeListener(new GraphTypeListener());
    }

    private void addComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.5f);
        this._checkBoxShowLabels = new JCheckBox("<html>Show<br>Usernames</html>", true);
        this._checkBoxShowLabels.setToolTipText("Show/hide the collaboration usernames of entities.");
        this._checkBoxShowLabels.setOpaque(false);
        this._checkBoxShowLabels.addItemListener(this);
        this._checkBoxShowLabels.setFont(new JCheckBox().getFont().deriveFont(0));
        this._checkBoxShowLabels.setForeground(UIManager.getLookAndFeelDefaults().getColor("ribbon-button-text-color"));
        this._checkBoxShowLabels.setEnabled(false);
        this.add(this._checkBoxShowLabels);
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        String topGraphType;
        Object item = e2.getItem();
        if (item == this._checkBoxShowLabels && (topGraphType = this.getTopGraphType()) != null) {
            EntityPropertyLabelSettings.setShowPropertyLabels(topGraphType, this._checkBoxShowLabels.isSelected());
        }
    }

    private String getTopGraphType() {
        GraphDataObject gdo;
        String type = null;
        TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
        if (topmost != null && (gdo = (GraphDataObject)topmost.getLookup().lookup(GraphDataObject.class)) != null) {
            type = GraphType.getType(gdo);
        }
        return type;
    }

    private void update() {
        String topGraphType = this.getTopGraphType();
        this._checkBoxShowLabels.setEnabled(topGraphType != null);
        if (topGraphType != null) {
            boolean selected = EntityPropertyLabelSettings.isShowPropertyLabels(topGraphType);
            this._checkBoxShowLabels.setSelected(selected);
        }
    }

    private class GraphTypeListener
    implements ChangeListener {
        private GraphTypeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e2) {
            AdditionalLabelsPanel.this.update();
        }
    }

    private class GraphListener
    implements PropertyChangeListener {
        private GraphListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("topmost".equals(evt.getPropertyName())) {
                AdditionalLabelsPanel.this.update();
            }
        }
    }
}

