/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexableField;

class DocumentProperty {
    private final String _name;
    private final String _prefix;
    private final List<IndexableField> _fields;
    private final TypeConverter _converter;

    public DocumentProperty(String name, TypeConverter converter) {
        this(name, "", converter);
    }

    public DocumentProperty(String name, String prefix, TypeConverter converter) {
        this._name = name;
        this._prefix = prefix;
        this._converter = converter;
        this._fields = new LinkedList<IndexableField>();
    }

    public void add(IndexableField field) {
        this._fields.add(field);
    }

    public List<IndexableField> getFields() {
        return this._fields;
    }

    public String getName() {
        return this._name;
    }

    public TypeConverter getConverter() {
        return this._converter;
    }

    public Object read() throws PandoraException {
        return this._converter.read(this._fields, this._prefix);
    }

    public String toString() {
        return "PropertyFields{name=" + this._name + ", prefix=" + this._prefix + ", converter=" + this._converter + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this._name);
        hash = 43 * hash + Objects.hashCode(this._prefix);
        hash = 43 * hash + Objects.hashCode(this._converter);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocumentProperty other = (DocumentProperty)obj;
        if (!Objects.equals(this._name, other._name)) {
            return false;
        }
        if (!Objects.equals(this._prefix, other._prefix)) {
            return false;
        }
        return Objects.equals(this._converter, other._converter);
    }
}

