/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.Payload;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.graph.state.RequestGraphMessage;
import com.paterva.maltego.collab.graph.state.SignalMessage;
import com.paterva.maltego.collab.graph.state.StateConnecting;
import com.paterva.maltego.collab.graph.state.StateGotGraph;

public class StateGetPeerGraph
extends StateConnecting.Timeout {
    private Participant _retrieveFrom;
    private int _retries;

    public StateGetPeerGraph(Participant retrieveFrom, int retries) {
        this._retrieveFrom = retrieveFrom;
        this._retries = retries;
    }

    @Override
    protected void onRun() {
        if (this._retrieveFrom == null) {
            this.handleError("", (Exception)((Object)new CollaborationException("Everyone left.", false)));
        } else if (this._retries <= 0) {
            this.handleError("", (Exception)((Object)new CollaborationException("Retries exceeded. Giving up.", false)));
        } else {
            this.progress(LogMessageLevel.Info, String.format("Requesting graph from %s. %d tries left.", this._retrieveFrom.getName(), this._retries), 50);
            this.sendGraphRequest(this._retrieveFrom);
        }
    }

    @Override
    protected long getTimeout() {
        return this.sessionInfo().getGraphRequestTimeout();
    }

    @Override
    protected void onTimeout() {
        this.debug("timeout exceeded");
        this.progress(LogMessageLevel.Warning, String.format("Timeout of %ds exceeded while waiting for graph from %s", (int)((float)this.getTimeout() / 1000.0f), this._retrieveFrom.getName()));
        this.retry();
    }

    @Override
    public void payloadsReceived(PayloadCollection payloads) throws CollaborationException {
        super.payloadsReceived(payloads);
        Payload signalPayload = payloads.first("signal", false);
        if (signalPayload != null) {
            try {
                SignalMessage signal = SignalMessage.parse(signalPayload.getBody());
                this.signalReceived(signalPayload.getFrom(), signal);
            }
            catch (CollaborationException ex) {
                this.handleError("Cannot parse signal message", (Exception)((Object)ex));
            }
        }
    }

    private void signalReceived(Participant from, SignalMessage signal) {
        if ("getgraph".equals(signal.getAction())) {
            switch (signal.getType()) {
                case Error: {
                    if (from.equals(this._retrieveFrom)) {
                        this.debug("Received error response from " + from.getName());
                        this.progress(LogMessageLevel.Info, String.format("%s is still waiting for a graph, let's try someone else", from.getName()));
                        this.retry();
                        break;
                    }
                    this.debug(String.format("Received error from %s but expected graph from %s", from, this._retrieveFrom));
                    break;
                }
                case Request: {
                    this.debug("Sending busy response to " + from.getName());
                    this.sendBusyResponse(from);
                    break;
                }
                case Response: {
                    this.debug("Received graph response from " + from.getName());
                    if (from.equals(this._retrieveFrom)) {
                        this.progress(LogMessageLevel.Info, String.format("Graph received from %s", from.getName(), 70));
                        PayloadCollection graph = this.createPayloads(from, (RequestGraphMessage)signal);
                        this.setNextState(new StateGotGraph(graph));
                        break;
                    }
                    this.debug(String.format("Received graph from %s but expected graph from %s", from, this._retrieveFrom));
                }
            }
        }
    }

    private void sendGraphRequest(Participant to) {
        try {
            this.tx().sendPayload(to.getID(), RequestGraphMessage.request().toXml());
        }
        catch (CollaborationException ex) {
            this.handleError("Failed to send graph request", (Exception)((Object)ex));
        }
    }

    private void sendBusyResponse(Participant to) {
        try {
            this.tx().sendPayload(to.getID(), SignalMessage.createErrorResponse("getgraph", 503, "busy").toXml());
        }
        catch (CollaborationException ex) {
            this.handleError("Failed to send busy response", (Exception)((Object)ex));
        }
    }

    private PayloadCollection createPayloads(Participant from, RequestGraphMessage signal) {
        PayloadCollection.List list = new PayloadCollection.List();
        String id = signal.getLastTransactionID();
        this.addPayload(list, id, from, "icons", signal.getIcons());
        this.addPayload(list, id, from, "especs", signal.getEntitySpecs());
        this.addPayload(list, id, from, "lspecs", signal.getLinkSpecs());
        this.addPayload(list, id, from, "xaction", signal.getGraph());
        this.addPayload(list, id, from, "layouts", signal.getLayoutSettings());
        this.addPayload(list, id, from, "collect", signal.getCollectionSettings());
        return list;
    }

    private void addPayload(PayloadCollection.List list, String id, Participant from, String type, String body) {
        if (body != null) {
            list.add(new Payload(id, from, type, body));
        }
    }

    private void retry() {
        Participant next = this.participants().chooseRandom(this._retrieveFrom);
        this.setNextState(new StateGetPeerGraph(next, this._retries - 1));
    }
}

