/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.cache.skeletons.EntitySkeletonProvider;
import com.paterva.maltego.graph.cache.skeletons.SkeletonProviders;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.views.collect.CollectionSettings;
import com.paterva.maltego.graph.store.views.impl.CollectStrategy;
import com.paterva.maltego.graph.store.views.impl.CollectionSnapshotWrapper;
import com.paterva.maltego.graph.store.views.impl.CollectionStats;
import com.paterva.maltego.graph.store.views.impl.InMemoryCollectionNodes;
import com.paterva.maltego.graph.store.views.impl.ModelSnapshotData;
import com.paterva.maltego.graph.store.views.impl.RuleLogger;
import com.paterva.maltego.graph.store.views.impl.UpdateWhenDisabled;
import com.paterva.maltego.graph.store.views.impl.ViewSnapShot;
import com.paterva.maltego.graph.store.views.impl.rules.bypass.BypassCollectionRule;
import com.paterva.maltego.graph.store.views.impl.rules.chain.ChainingCollectionRule;
import com.paterva.maltego.graph.store.views.impl.rules.neighbour.NeighbourCollectionRule;
import com.paterva.maltego.graph.store.views.impl.rules.standalone.StandAloneCollectionRule;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class UpdateView {
    private static final boolean ALWAYS_TOUCH_ALL_ENTITIES = true;
    private static final boolean CHECK_ARGS = false;
    private static final boolean RE_DO_FAILURES = false;
    private static final Logger LOG = Logger.getLogger(UpdateView.class.getName());
    private final List<CollectStrategy> _collectionStrategies = new ArrayList<CollectStrategy>();
    private final InMemoryCollectionNodes _collectionNodes;
    private final UpdateWhenDisabled _disabledUpdator;
    private final EntitySkeletonProvider _entitiesForGraph;
    private final GraphID _graphID;
    private final CollectionStats _collectionStats;
    private final GraphDataStoreReader _modelDataReader;
    private final GraphStructureReader _modelStructureReader;
    private final Map<EntityID, ViewEntity> _viewEntities;
    private final Map<LinkID, ViewLink> _viewLinks;
    private final Map<EntityID, EntityID> _modelEntityToViewEntity;
    private final Map<LinkID, LinkID> _modelLinkToViewLink;
    private final Set<EntityID> _viewEntitiesWithoutLinks;

    UpdateView(InMemoryCollectionNodes collectionNodes, GraphID graphID) throws GraphStoreException {
        this._collectionNodes = collectionNodes;
        this._graphID = graphID;
        GraphStore model = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
        this._modelStructureReader = model.getGraphStructureStore().getStructureReader();
        this._modelDataReader = model.getGraphDataStore().getDataStoreReader();
        this._entitiesForGraph = SkeletonProviders.entitiesForGraph((GraphID)this._graphID);
        this._viewEntities = this._collectionNodes.getViewEntities();
        this._viewLinks = this._collectionNodes.getViewLinks();
        this._modelEntityToViewEntity = this._collectionNodes.getModelEntityToViewEntity();
        this._modelLinkToViewLink = this._collectionNodes.getModelLinkToViewLink();
        this._viewEntitiesWithoutLinks = this._collectionNodes.getViewEntitiesWithoutLinks();
        this._collectionStrategies.add(new RuleLogger(new StandAloneCollectionRule(this._collectionNodes)));
        this._collectionStrategies.add(new RuleLogger(new NeighbourCollectionRule(this._collectionNodes)));
        this._collectionStrategies.add(new RuleLogger(new CollectionSnapshotWrapper(new RuleLogger(new ChainingCollectionRule(this._collectionNodes)))));
        this._collectionStrategies.add(new RuleLogger(new BypassCollectionRule(this._collectionNodes)));
        this._disabledUpdator = new UpdateWhenDisabled(this._viewEntities, this._viewLinks, this._modelDataReader, this._modelStructureReader, this._modelEntityToViewEntity, this._modelLinkToViewLink, this._viewEntitiesWithoutLinks);
        this._collectionStats = new CollectionStats(this._viewEntities, this._viewLinks, this._modelEntityToViewEntity, this._modelLinkToViewLink);
    }

    private boolean isViewEmpty() {
        return this._viewEntities.isEmpty();
    }

    private void collectLoop(ModelSnapshotData msd, Map<EntityID, ViewEntity> viewEntitiesSnapShot, Map<LinkID, ViewLink> viewLinksSnapShot, Map<EntityID, EntityLinks> uncollectedEntitiesWithMods, Map<LinkID, LinkEntityIDs> uncollectedLinksWithMods) throws GraphStoreException {
        for (CollectStrategy strategy : this._collectionStrategies) {
            strategy.collect(msd, uncollectedEntitiesWithMods, uncollectedLinksWithMods);
        }
        if (!uncollectedEntitiesWithMods.isEmpty() || !uncollectedLinksWithMods.isEmpty()) {
            throw new IllegalStateException("Not all uncolleted links/entities were collected");
        }
        msd.updateCollections(this._viewEntities, this._viewLinks, viewEntitiesSnapShot, viewLinksSnapShot, this._modelEntityToViewEntity, this._modelLinkToViewLink, this._viewEntitiesWithoutLinks);
        msd.updateViewMods(viewEntitiesSnapShot, viewLinksSnapShot);
    }

    private Set<EntityID> lookupTouchedViewEntities(GraphStructureMods incomingModelStructureMods, GraphDataMods incomingModelDataMods) throws GraphStoreException {
        HashSet<EntityID> touchedViewEntities = new HashSet<EntityID>();
        GraphStructureMods imsm = GraphStructureMods.weakCopy((GraphStructureMods)incomingModelStructureMods);
        GraphDataMods imdm = GraphDataMods.weakCopy((GraphDataMods)incomingModelDataMods);
        for (CollectStrategy strategy : this._collectionStrategies) {
            touchedViewEntities.addAll(strategy.determineTouchedViewEntities(imsm, imdm));
        }
        return touchedViewEntities;
    }

    private GraphStructureMods uncollectAllAndCollectAll(boolean doLayoutNew) throws GraphStoreException {
        HashSet<EntityID> entitiesRemoved = new HashSet<EntityID>(this._viewEntities.keySet());
        HashMap<LinkID, LinkEntityIDs> linksRemoved = new HashMap<LinkID, LinkEntityIDs>();
        for (Map.Entry<LinkID, ViewLink> entry : this._viewLinks.entrySet()) {
            LinkID key = entry.getKey();
            LinkEntityIDs value = entry.getValue().getEntities();
            linksRemoved.put(key, value);
        }
        Set<EntityID> modelEntities = this.getAllModelEntities();
        Set<LinkID> modelLinks = this.getAllModelLinks();
        this._viewEntities.clear();
        this._viewLinks.clear();
        this._modelLinkToViewLink.clear();
        this._modelEntityToViewEntity.clear();
        this._viewEntitiesWithoutLinks.clear();
        GraphStructureMods incomingMods = new GraphStructureMods();
        incomingMods.getEntitiesAdded().addAll(modelEntities);
        incomingMods.getLinksAdded().addAll(modelLinks);
        incomingMods.makeReadOnly();
        GraphStructureMods collectedViewMods = this.update(incomingMods, null);
        GraphStructureMods viewMods = new GraphStructureMods();
        viewMods.setLayoutNew(doLayoutNew);
        viewMods.getEntitiesAdded().addAll(collectedViewMods.getEntitiesAdded());
        viewMods.getEntitiesAdded().removeAll(entitiesRemoved);
        viewMods.getEntitiesRemoved().addAll(entitiesRemoved);
        viewMods.getEntitiesRemoved().removeAll(collectedViewMods.getEntitiesAdded());
        viewMods.getLinksAdded().addAll(collectedViewMods.getLinksAdded());
        viewMods.getLinksAdded().removeAll(linksRemoved.keySet());
        viewMods.getLinksRemoved().putAll(linksRemoved);
        viewMods.getLinksRemoved().keySet().removeAll(collectedViewMods.getLinksAdded());
        return viewMods;
    }

    private GraphStructureMods uncollectAll() throws GraphStoreException {
        GraphStructureMods viewMods = new GraphStructureMods();
        viewMods.setLayoutNew(true);
        this.uncollectEntities(viewMods);
        this.uncollectLinks(viewMods);
        return viewMods;
    }

    private Set<EntityID> getAllModelEntities() {
        LinkedList<EntityID> entitiesList = new LinkedList<EntityID>();
        for (Map.Entry<EntityID, ViewEntity> entry : this._viewEntities.entrySet()) {
            EntityID key = entry.getKey();
            ViewEntity value = entry.getValue();
            if (value.isCollection()) {
                entitiesList.addAll(value.getCollection());
                continue;
            }
            entitiesList.add(key);
        }
        return new HashSet<EntityID>(entitiesList);
    }

    private Set<LinkID> getAllModelLinks() {
        LinkedList<LinkID> linksList = new LinkedList<LinkID>();
        for (Map.Entry<LinkID, ViewLink> entry : this._viewLinks.entrySet()) {
            LinkID key = entry.getKey();
            ViewLink value = entry.getValue();
            if (value.isCollection()) {
                linksList.addAll(value.getCollection());
                continue;
            }
            linksList.add(key);
        }
        return new HashSet<LinkID>(linksList);
    }

    private void uncollectEntities(GraphStructureMods viewMods) throws GraphStoreException {
        Set entitiesAdded = viewMods.getEntitiesAdded();
        Set entitiesRemoved = viewMods.getEntitiesRemoved();
        LinkedList<EntityID> entitiesRemovedList = new LinkedList<EntityID>();
        LinkedList<ViewEntity> viewEntitiesToReAdd = new LinkedList<ViewEntity>();
        for (Map.Entry<EntityID, ViewEntity> entry : this._viewEntities.entrySet()) {
            EntityID collectionEntity = entry.getKey();
            ViewEntity viewEntity = entry.getValue();
            if (viewEntity.isCollection()) {
                entitiesAdded.addAll(viewEntity.getCollection());
                entitiesRemovedList.add(collectionEntity);
            } else {
                viewEntity.getCollection().add(collectionEntity);
            }
            viewEntitiesToReAdd.add(viewEntity);
        }
        entitiesRemoved.addAll(entitiesRemovedList);
        this._viewEntities.clear();
        this._modelEntityToViewEntity.clear();
        for (ViewEntity viewEntity : viewEntitiesToReAdd) {
            String type = viewEntity.getType();
            for (EntityID entityID : viewEntity.getCollection()) {
                EntityLinks entLinks = new EntityLinks();
                ViewEntity newViewEntity = new ViewEntity(type, entLinks);
                this._viewEntities.put(entityID, newViewEntity);
                this._modelEntityToViewEntity.put(entityID, entityID);
            }
        }
        Set<EntityID> keySet = this._viewEntities.keySet();
        Map incoming = this._modelStructureReader.getIncoming(keySet);
        Map outgoing = this._modelStructureReader.getOutgoing(keySet);
        LinkedList<EntityID> viewEntitiesWithoutLinks = new LinkedList<EntityID>();
        this._viewEntitiesWithoutLinks.clear();
        for (Map.Entry entry : incoming.entrySet()) {
            EntityID key = (EntityID)entry.getKey();
            EntityLinks links = this._viewEntities.get(key).getAllLinks();
            Set incommingLinks = (Set)incoming.get(key);
            Set outgoingLinks = (Set)outgoing.get(key);
            links.clear();
            links.getModelIncomingLinks().addAll(incommingLinks);
            links.getModelOutgoingLinks().addAll(outgoingLinks);
            links.getViewIncomingLinks().addAll(incommingLinks);
            links.getViewOutgoingLinks().addAll(outgoingLinks);
            if (links.hasViewOrModelLinks()) continue;
            viewEntitiesWithoutLinks.add(key);
        }
        this._viewEntitiesWithoutLinks.addAll(viewEntitiesWithoutLinks);
    }

    private void uncollectLinks(GraphStructureMods viewMods) throws GraphStoreException {
        Set linksAdded = viewMods.getLinksAdded();
        Map linksRemoved = viewMods.getLinksRemoved();
        LinkedList<LinkID> linksList = new LinkedList<LinkID>();
        for (Map.Entry<LinkID, ViewLink> entry : this._viewLinks.entrySet()) {
            LinkID collectionLink = entry.getKey();
            ViewLink viewLink = entry.getValue();
            if (!viewLink.isCollection()) continue;
            linksAdded.addAll(viewLink.getCollection());
            linksRemoved.put(collectionLink, viewLink.getEntities());
            linksList.add(collectionLink);
        }
        HashSet linksToRemove = new HashSet(linksList);
        this._modelLinkToViewLink.keySet().removeAll(linksToRemove);
        this._viewLinks.keySet().removeAll(linksToRemove);
        Map entities = this._modelStructureReader.getEntities((Collection)linksAdded);
        for (Map.Entry entry : entities.entrySet()) {
            LinkID linkId = (LinkID)entry.getKey();
            LinkEntityIDs ids = (LinkEntityIDs)entry.getValue();
            ViewLink viewLink = new ViewLink(ids);
            this._viewLinks.put(linkId, viewLink);
            this._modelLinkToViewLink.put(linkId, linkId);
        }
    }

    public GraphStructureMods updateRedoable(GraphStructureMods structureMods, GraphDataMods dataMods) throws GraphStoreException {
        LOG.fine("STARTING COLLECTION");
        if (structureMods == null) {
            structureMods = new GraphStructureMods();
        }
        if (this.isOnlyNewPinnedEntities(structureMods)) {
            for (EntityID entityID : structureMods.getEntitiesAdded()) {
                String type = this._modelDataReader.getEntityType(entityID);
                this._viewEntities.put(entityID, new ViewEntity(type, new EntityLinks()));
                this._viewEntitiesWithoutLinks.add(entityID);
                this._modelEntityToViewEntity.put(entityID, entityID);
            }
            return structureMods;
        }
        if (this.isOnlyPinnedViewEntities(structureMods)) {
            return structureMods;
        }
        CollectionSettings collectionSettings = CollectionSettings.getDefault();
        int minRequiredEntitiesPerNode = collectionSettings.getMinRequiredEntitiesPerNode(this._graphID);
        if (!collectionSettings.isEnabled(this._graphID)) {
            return this._disabledUpdator.update(structureMods);
        }
        if (dataMods == null) {
            dataMods = new GraphDataMods();
        }
        GraphStructureMods viewMods = new GraphStructureMods();
        viewMods.setLayoutNew(structureMods.isLayoutNew());
        viewMods.getEntitiesPinned().addAll(structureMods.getEntitiesPinned());
        viewMods.getEntitiesUnpinned().addAll(structureMods.getEntitiesUnpinned());
        HashMap<EntityID, ViewEntity> viewEntitiesSnapShot = new HashMap<EntityID, ViewEntity>();
        HashMap<LinkID, ViewLink> viewLinksSnapShot = new HashMap<LinkID, ViewLink>();
        HashMap<EntityID, EntityLinks> uncollectedEntitiesWithMods = new HashMap<EntityID, EntityLinks>();
        HashMap<LinkID, LinkEntityIDs> uncollectedLinksWithMods = new HashMap<LinkID, LinkEntityIDs>();
        HashMap<EntityID, EntityLinks> uncollectedEntities = new HashMap<EntityID, EntityLinks>();
        HashMap<LinkID, LinkEntityIDs> uncollectedLinks = new HashMap<LinkID, LinkEntityIDs>();
        Object uncollectedEntitiesWithModsCopy = null;
        Object uncollectedLinksWithModsCopy = null;
        boolean recollectingEntireGraph = true;
        if (!this.isViewEmpty()) {
            Set<EntityID> touchedViewEntities = this._viewEntities.keySet();
            ViewSnapShot.createViewSnapShot(this._collectionNodes, touchedViewEntities, viewEntitiesSnapShot, viewLinksSnapShot);
            ViewSnapShot.uncollectViewSnapShot(this._collectionNodes, viewEntitiesSnapShot, viewLinksSnapShot, uncollectedEntities, uncollectedLinks, structureMods, recollectingEntireGraph);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "uncollectedEntities:\n{0}", ((Object)uncollectedEntities).toString());
        }
        ViewSnapShot.applyIncommingMods(this._collectionNodes, uncollectedEntities, uncollectedLinks, uncollectedEntitiesWithMods, uncollectedLinksWithMods, structureMods);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "uncollectedEntitiesWithMods:\n{0}\n\n", ((Object)uncollectedEntitiesWithMods).toString());
        }
        this._collectionStats.logMetadata(viewEntitiesSnapShot, viewLinksSnapShot, uncollectedEntitiesWithMods, uncollectedLinksWithMods);
        Set uncollectedEntitiesWithModsKeySet = uncollectedEntitiesWithMods.keySet();
        ModelSnapshotData msd = new ModelSnapshotData(viewMods, this._viewEntities, this._modelStructureReader.getPinned(uncollectedEntitiesWithModsKeySet), this._entitiesForGraph.getEntitySkeletons(uncollectedEntitiesWithModsKeySet), this._modelDataReader.getEntityTypes(uncollectedEntitiesWithModsKeySet), minRequiredEntitiesPerNode, recollectingEntireGraph, ModelSnapshotData.deepCopySnapshotEntities(uncollectedEntitiesWithMods), ModelSnapshotData.deepCopySnapshotLinks(uncollectedLinksWithMods));
        this.collectLoop(msd, viewEntitiesSnapShot, viewLinksSnapShot, uncollectedEntitiesWithMods, uncollectedLinksWithMods);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "All view links {0}", this._viewLinks.keySet().toString());
            LOG.log(Level.FINE, "All view entities {0}", this._viewEntities.keySet().toString());
            LOG.log(Level.FINE, "Mods {0}", viewMods.toString());
        }
        return viewMods;
    }

    public GraphStructureMods update(GraphStructureMods structureMods, GraphDataMods dataMods) throws GraphStoreException {
        return this.updateRedoable(structureMods, dataMods);
    }

    public GraphStructureMods recollectAll() throws GraphStoreException {
        GraphStructureMods viewMods;
        if (CollectionSettings.getDefault().isEnabled(this._graphID)) {
            viewMods = this.uncollectAllAndCollectAll(true);
        } else if (!CollectionSettings.getDefault().didLimitChange()) {
            viewMods = this.uncollectAll();
        } else {
            CollectionSettings.getDefault().limitChangeHandled();
            viewMods = null;
        }
        return viewMods;
    }

    private boolean isOnlyNewPinnedEntities(GraphStructureMods structureMods) {
        return !structureMods.getEntitiesAdded().isEmpty() && structureMods.getEntitiesRemoved().isEmpty() && structureMods.getEntitiesUnpinned().isEmpty() && structureMods.getLinksAdded().isEmpty() && structureMods.getLinksRemoved().isEmpty() && structureMods.getEntitiesAdded().equals(structureMods.getEntitiesPinned());
    }

    private boolean isOnlyPinnedViewEntities(GraphStructureMods structureMods) {
        return structureMods.getEntitiesAdded().isEmpty() && structureMods.getEntitiesRemoved().isEmpty() && structureMods.getEntitiesUnpinned().isEmpty() && structureMods.getLinksAdded().isEmpty() && structureMods.getLinksRemoved().isEmpty() && !structureMods.getEntitiesPinned().isEmpty() && this._viewEntities.keySet().containsAll(structureMods.getEntitiesPinned());
    }
}

