/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class CollectionStats {
    private static final Logger LOG = Logger.getLogger(CollectionStats.class.getName());
    private double _viewSnapshotEntPerAvg = 0.0;
    private double _viewSnapshotLinkPerAvg = 0.0;
    private double _modelSnapshotEntPerAvg = 0.0;
    private double _modelSnapshotLinkPerAvg = 0.0;
    private double _logMetadataCounter = 0.0;
    private final Map<EntityID, ViewEntity> _viewEntities;
    private final Map<LinkID, ViewLink> _viewLinks;
    private final Map<EntityID, EntityID> _modelEntityToViewEntity;
    private final Map<LinkID, LinkID> _modelLinkToViewLink;

    public CollectionStats(Map<EntityID, ViewEntity> viewEntities, Map<LinkID, ViewLink> viewLinks, Map<EntityID, EntityID> modelEntityToViewEntity, Map<LinkID, LinkID> modelLinkToViewLink) {
        this._viewEntities = viewEntities;
        this._viewLinks = viewLinks;
        this._modelEntityToViewEntity = modelEntityToViewEntity;
        this._modelLinkToViewLink = modelLinkToViewLink;
    }

    void logMetadata(Map<EntityID, ViewEntity> viewEntitiesSnapShot, Map<LinkID, ViewLink> viewLinksSnapShot, Map<EntityID, EntityLinks> uncollectedEntitiesWithMods, Map<LinkID, LinkEntityIDs> uncollectedLinksWithMods) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        int viewEntCount = this._viewEntities.size();
        int viewLinkCount = this._viewLinks.size();
        int modelEntCount = this._modelEntityToViewEntity.size();
        int modelLinkCount = this._modelLinkToViewLink.size();
        int viewEntSnapshotCount = viewEntitiesSnapShot.size();
        int viewLinkSnapshotCount = viewLinksSnapShot.size();
        int modelEntSnapshotWithModsCount = uncollectedEntitiesWithMods.size();
        int modelLinkSnapshotWithModsCount = uncollectedLinksWithMods.size();
        double viewSnapshotEntPer = viewEntCount == 0 ? 0.0 : 100.0 * ((double)viewEntSnapshotCount / (double)viewEntCount);
        double viewSnapshotLinkPer = viewLinkCount == 0 ? 0.0 : 100.0 * ((double)viewLinkSnapshotCount / (double)viewLinkCount);
        double modelSnapshotEntPer = modelEntCount == 0 ? 0.0 : 100.0 * ((double)modelEntSnapshotWithModsCount / (double)modelEntCount);
        double modelSnapshotLinkPer = modelLinkCount == 0 ? 0.0 : 100.0 * ((double)modelLinkSnapshotWithModsCount / (double)modelLinkCount);
        this._viewSnapshotEntPerAvg = (this._viewSnapshotEntPerAvg * this._logMetadataCounter + viewSnapshotEntPer) / (this._logMetadataCounter + 1.0);
        this._viewSnapshotLinkPerAvg = (this._viewSnapshotLinkPerAvg * this._logMetadataCounter + viewSnapshotLinkPer) / (this._logMetadataCounter + 1.0);
        this._modelSnapshotEntPerAvg = (this._modelSnapshotEntPerAvg * this._logMetadataCounter + modelSnapshotEntPer) / (this._logMetadataCounter + 1.0);
        this._modelSnapshotLinkPerAvg = (this._modelSnapshotLinkPerAvg * this._logMetadataCounter + modelSnapshotLinkPer) / (this._logMetadataCounter + 1.0);
        this._logMetadataCounter += 1.0;
        LOG.log(Level.FINE, "------------------------------------------------");
        LOG.log(Level.FINE, "-----------------Collection stats---------------");
        LOG.log(Level.FINE, "------------------------------------------------");
        LOG.log(Level.FINE, "1. Counters");
        LOG.log(Level.FINE, "     ViewEntCount {0}", viewEntCount);
        LOG.log(Level.FINE, "     ViewLinkCount {0}", viewLinkCount);
        LOG.log(Level.FINE, "     ModelEntCount {0}", modelEntCount);
        LOG.log(Level.FINE, "     ModelLinkCount {0}", modelLinkCount);
        LOG.log(Level.FINE, "     ViewEntSnapshotCount {0}", viewEntSnapshotCount);
        LOG.log(Level.FINE, "     ViewLinkSnapshotCount {0}", viewLinkSnapshotCount);
        LOG.log(Level.FINE, "     ModelEntSnapshotWithModsCount {0}", modelEntSnapshotWithModsCount);
        LOG.log(Level.FINE, "     ModelLinkSnapshotWithModsCount {0}", modelLinkSnapshotWithModsCount);
        LOG.log(Level.FINE, "2. Percentage");
        LOG.log(Level.FINE, "     View Entities in snapshot {0}%", viewSnapshotEntPer);
        LOG.log(Level.FINE, "     View Links in snapshot {0}%", viewSnapshotLinkPer);
        LOG.log(Level.FINE, "     Model Entities with mods in snapshot {0}%", modelSnapshotEntPer);
        LOG.log(Level.FINE, "     Model Links with mods in snapshot {0}%", modelSnapshotLinkPer);
        LOG.log(Level.FINE, "2. Average Percentage");
        LOG.log(Level.FINE, "     View Entities in snapshot {0}%", this._viewSnapshotEntPerAvg);
        LOG.log(Level.FINE, "     View Links in snapshot {0}%", this._viewSnapshotLinkPerAvg);
        LOG.log(Level.FINE, "     Model Entities with mods in snapshot {0}%", this._modelSnapshotEntPerAvg);
        LOG.log(Level.FINE, "     Model Links with mods in snapshot {0}%", this._modelSnapshotLinkPerAvg);
    }
}

