/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.typing.editing.controls.DateRangePickerFixedPopupContent;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateRangePresets;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.FixedDateRange;
import com.paterva.maltego.typing.types.PresetsRelative;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DateRangePickerPresetsPopupContent {
    private AtomicBoolean _allowPresetsComboActions = new AtomicBoolean(true);
    private PresetsRelative _presetsComboSelectedItem = null;
    private JPanel _presetsRelativeDateRangePanel;
    private JComboBox _presetsCombo;
    private DateRangePickerFixedPopupContent.DateTimeRangePresetsChangeAction _callBack;
    private DateRange _dateRange;
    private AtomicBoolean _updating = new AtomicBoolean(false);

    public DateRangePickerPresetsPopupContent() {
        this(null, null);
    }

    public DateRangePickerPresetsPopupContent(DateRange dateRange, DateRangePickerFixedPopupContent.DateTimeRangePresetsChangeAction cb) {
        this._callBack = cb;
        this._dateRange = dateRange == null ? null : DateRange.createCopy((DateRange)dateRange);
        this.initComponents(this._dateRange);
    }

    public void setDateTimeRangePresetsChangeActionCallBack(DateRangePickerFixedPopupContent.DateTimeRangePresetsChangeAction cb) {
        this._callBack = cb;
    }

    public void setDateRange(DateRange dateRange) {
        if (dateRange != null) {
            DateRange temp1 = DateRange.createCopy((DateRange)dateRange);
            DateRange temp2 = DateRange.createCopy((DateRange)dateRange);
            this._dateRange = temp1;
            this.setPresetRelativeItem(dateRange.getRelativeItem());
            this._updating.set(true);
            this._dateRange = temp2;
            this._updating.set(false);
            if (this._callBack != null) {
                this._callBack.perform(this._dateRange);
            }
        }
    }

    public DateRange getDateRange() {
        return this._dateRange;
    }

    public JPanel getPresetsRelativeDateRangePanel() {
        return this._presetsRelativeDateRangePanel;
    }

    public void setIsUpdating(boolean state) {
        this._updating.set(state);
    }

    private void initComponents(DateRange dateRange) {
        this._presetsRelativeDateRangePanel = new DateRangePickerFixedPopupContent.TransparentPanel();
        this._presetsRelativeDateRangePanel.setToolTipText("Relative Date Range");
        this._presetsCombo = new JComboBox();
        this._allowPresetsComboActions.set(false);
        this._presetsCombo.setEditable(false);
        this._presetsCombo.setModel(new DefaultComboBoxModel<PresetsRelative>(PresetsRelative.values()));
        this._presetsCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (!DateRangePickerPresetsPopupContent.this._updating.get()) {
                    DateRangePickerPresetsPopupContent.this.presetsComboItemStateChanged(evt);
                }
            }
        });
        this._presetsCombo.setSelectedIndex(-1);
        if (this._presetsComboSelectedItem == null) {
            this._presetsComboSelectedItem = PresetsRelative.PRESETS_SINCE_UNIX_EPOCH_TIME;
        }
        this.setPresetRelativeItem(this._presetsComboSelectedItem);
        this._allowPresetsComboActions.set(true);
        this._presetsCombo.addPopupMenuListener(new PresetPopupMenuListenerImpl());
        GridBagConstraints gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 18, 1, new Insets(3, 0, 3, 0), 5, 0);
        this._presetsRelativeDateRangePanel.add((Component)new LabelWithBackground("Presets"), gbc);
        gbc = new GridBagConstraints(1, 1, 2, 1, 1.0, 0.5, 18, 1, new Insets(3, 0, 3, 0), 10, 0);
        this._presetsRelativeDateRangePanel.add((Component)this._presetsCombo, gbc);
        if (dateRange == null) {
            this.setDateRange(new DateRange(this._presetsComboSelectedItem));
        }
    }

    private FixedDateRange getPresetDateRange() {
        return DateRangePresets.getPresetDateRange((PresetsRelative)this._presetsComboSelectedItem);
    }

    private void setPresetRelativeItem(PresetsRelative presetRelativeItem) {
        this._presetsCombo.setSelectedItem(presetRelativeItem);
    }

    public PresetsRelative getPresetRelativeItem() {
        return this._presetsComboSelectedItem;
    }

    private void presetsComboItemStateChanged(ItemEvent evt) {
        if (this._allowPresetsComboActions.get() && evt.getStateChange() == 1) {
            PresetsRelative itemName;
            this._presetsComboSelectedItem = itemName = (PresetsRelative)evt.getItem();
            this._dateRange = new DateRange(this._dateRange.getFixedDateRange(), this._presetsComboSelectedItem, true);
            if (this._callBack != null) {
                this._callBack.perform(this._dateRange);
            }
        }
    }

    public boolean isOnSameDay() {
        boolean isOnSameDay = false;
        FixedDateRange presetDateRange = this.getPresetDateRange();
        DateTime fromDateTime = presetDateRange.getFromDate();
        DateTime toDateTime = presetDateRange.getToDate();
        if (toDateTime != null && fromDateTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            isOnSameDay = sdf.format(fromDateTime.getDate()).equals(sdf.format(toDateTime.getDate()));
        }
        return isOnSameDay;
    }

    private class PresetPopupMenuListenerImpl
    implements PopupMenuListener {
        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.update();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        private void update() {
            if (!DateRangePickerPresetsPopupContent.this._updating.get()) {
                DateRangePickerPresetsPopupContent.this._allowPresetsComboActions.set(false);
                DateRangePickerPresetsPopupContent.this._dateRange = new DateRange(DateRangePickerPresetsPopupContent.this._dateRange.getFixedDateRange(), DateRangePickerPresetsPopupContent.this._presetsComboSelectedItem, true);
                if (DateRangePickerPresetsPopupContent.this._callBack != null) {
                    DateRangePickerPresetsPopupContent.this._callBack.perform(DateRangePickerPresetsPopupContent.this._dateRange);
                }
                DateRangePickerPresetsPopupContent.this._allowPresetsComboActions.set(true);
            }
        }
    }
}

