/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.ctxmenu.WindowPopupManager;
import com.paterva.maltego.util.ui.treelist.AbstractTreeListItemPanel;
import com.paterva.maltego.util.ui.treelist.ConstraintUtils;
import com.paterva.maltego.util.ui.treelist.DefaultTreeListItemRenderer;
import com.paterva.maltego.util.ui.treelist.ExpandButton2;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItemRenderer;
import com.paterva.maltego.util.ui.treelist.TreeListItemToolbar;
import com.paterva.maltego.util.ui.treelist.TreeListSettings;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class TreeListItemPanel
extends AbstractTreeListItemPanel {
    private final TreeListItem _item;
    private ExpandButton2 _expandButton;
    private final JLabel _icon = new JLabel();
    private final JLabel _nameLabel = new JLabel();
    private final JLabel _descriptionLabel = new JLabel();
    private final JTextArea _descriptionTextArea = new DescriptionTextArea();
    private final TreeListItemToolbar _toolbar = new TreeListItemToolbar();
    private UpdateComponentsListener _updateComponentsListener;
    private AWTEventListener _globalEnterExitListener;
    private boolean _isDeflating = false;
    private boolean _isExpanding = false;
    private boolean _isHovered = false;
    private boolean _isAdded = false;
    private boolean _isInitialized = false;
    private EnterExitListener _enterExitListener;
    private final TreeListItemRenderer _renderer;

    public TreeListItemPanel(TreeListItem item) {
        this(item, new DefaultTreeListItemRenderer());
    }

    public TreeListItemPanel(TreeListItem item, TreeListItemRenderer renderer) {
        super(new GridBagLayout(), true);
        this._item = item;
        this._renderer = renderer;
    }

    TreeListItem getTreeListItem() {
        return this._item;
    }

    @Override
    public boolean isDeflating() {
        return this._isDeflating;
    }

    @Override
    public void setDeflating(boolean deflating) {
        if (this._isDeflating != deflating) {
            this._isDeflating = deflating;
            this.update();
        }
    }

    public boolean isExpanding() {
        return this._isExpanding;
    }

    public void setExpanding(boolean expanding) {
        if (this._isExpanding != expanding) {
            this._isExpanding = expanding;
            this.update();
        }
    }

    public boolean isSelected() {
        return this._item.isSelected();
    }

    public boolean isLeaf() {
        return this._item.getChildren().isEmpty();
    }

    private void update() {
        boolean visible;
        boolean updateComponents = false;
        boolean bl = visible = this._isAdded && this.isVisible();
        if ((this._isExpanding || visible) && !this._isInitialized) {
            this.initialize();
            updateComponents = true;
        }
        if (visible && !this._isExpanding && !this._isDeflating) {
            updateComponents = this.addListeners();
        } else {
            this.removeListeners();
        }
        if (updateComponents) {
            this.updateComponents();
        }
    }

    private void initialize() {
        this._isInitialized = true;
        this.setOpaque(false);
        EmptyBorder border = new EmptyBorder(3, 4, 1, 2);
        if (this.isLeaf()) {
            if (this._item.getDefaultAction() != null) {
                border = new EmptyBorder(4, 4, 4, 2);
            } else if (this._item.getName() != null && this._item.getName().startsWith("machineset.")) {
                border = new EmptyBorder(4, 4, 3, 2);
            }
        }
        this.setBorder(border);
        this.addComponents();
    }

    private void addComponents() {
        this._expandButton = new ExpandButton2(new ExpandAction());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.add((Component)this._expandButton, gridBagConstraints);
        this._icon.setBorder(new EmptyBorder(0, 2, 0, 2));
        this._icon.setIcon(this._renderer.displayIcon(this._item) ? this._item.getIcon() : null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.add((Component)this._icon, gridBagConstraints);
        Font font = this._renderer.getDisplayNameFont(this._item);
        if (font != null) {
            this._nameLabel.setFont(font);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._nameLabel, gridBagConstraints);
        Font descriptionFont = this._renderer.getDescriptionFont(this._item);
        if (descriptionFont != null) {
            this._descriptionLabel.setFont(descriptionFont);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._descriptionLabel, gridBagConstraints);
        this._descriptionTextArea.setEditable(false);
        this._descriptionTextArea.setLineWrap(true);
        this._descriptionTextArea.setWrapStyleWord(true);
        this._descriptionTextArea.setMargin(new Insets(0, 0, 0, 0));
        this._descriptionTextArea.setOpaque(false);
        this._descriptionTextArea.setFont(descriptionFont);
        this._descriptionTextArea.setForeground(Color.GRAY);
        this._descriptionTextArea.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._descriptionTextArea, gridBagConstraints);
        this._toolbar.setOpaque(false);
        this._toolbar.setLayout(new BoxLayout(this._toolbar, 0));
        this._toolbar.setBorder(new EmptyBorder(0, 2, 0, 0));
        this._toolbar.setActions(this._item.getToolbarActions());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        this.add((Component)this._toolbar, gridBagConstraints);
    }

    private void updateExpandButton() {
        this._expandButton.setExpanded(this._item.isExpanded());
        this._expandButton.setVisible(!this._item.getChildren().isEmpty());
    }

    private void updateComponents() {
        TreeListSettings treeListSettings = TreeListSettings.getInstance();
        this.updateExpandButton();
        String description = this._item.getDescription();
        boolean validDescription = !StringUtilities.isNullOrEmpty((String)description);
        Color descriptionColor = this._renderer.getDescriptionFgColor(this._item, this._item.isSelected(), this._isHovered);
        boolean isSingleLineDescription = validDescription && treeListSettings.isShowSingleLineDescriptions() && this._item.mayShowDescription();
        this._descriptionLabel.setText(validDescription ? description : "");
        this._descriptionLabel.setForeground(descriptionColor);
        this._descriptionLabel.setVisible(isSingleLineDescription);
        this._descriptionLabel.setToolTipText(description);
        boolean isMultiLineDescription = validDescription && treeListSettings.isShowMultiLineDescriptions() && this._item.mayShowDescription();
        this._descriptionTextArea.setText(validDescription ? description : "");
        this._descriptionTextArea.setForeground(descriptionColor);
        this._descriptionTextArea.setVisible(isMultiLineDescription);
        this._descriptionTextArea.setToolTipText(description);
        this._nameLabel.setText(this._item.getDisplayName());
        this._nameLabel.setForeground(this.getForeground());
        this._nameLabel.setToolTipText(description);
        int gridHeight = isSingleLineDescription || isMultiLineDescription ? 1 : 0;
        ConstraintUtils.setGridHeight(this, this._nameLabel, gridHeight);
        this.setToolTipText(description);
        this.repaint();
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this._nameLabel.addMouseListener(l);
        this._descriptionLabel.addMouseListener(l);
        this._descriptionTextArea.addMouseListener(l);
        super.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this._nameLabel.removeMouseListener(l);
        this._descriptionLabel.removeMouseListener(l);
        this._descriptionTextArea.removeMouseListener(l);
        super.removeMouseListener(l);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._isAdded = true;
        this.update();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._isAdded = false;
        this.update();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.update();
    }

    private boolean addListeners() {
        if (this._updateComponentsListener == null) {
            this._updateComponentsListener = new UpdateComponentsListener();
            this._item.addPropertyChangeListener(this._updateComponentsListener);
            TreeListSettings.getInstance().addPropertyChangeListener(this._updateComponentsListener);
            this._globalEnterExitListener = new EnterExitMouseHandler();
            Toolkit.getDefaultToolkit().addAWTEventListener(this._globalEnterExitListener, 16L);
            this._enterExitListener = new EnterExitListener();
            this.addMouseListener(this._enterExitListener);
            return true;
        }
        return false;
    }

    private void removeListeners() {
        if (this._updateComponentsListener != null) {
            this._item.removePropertyChangeListener(this._updateComponentsListener);
            TreeListSettings.getInstance().removePropertyChangeListener(this._updateComponentsListener);
            this._updateComponentsListener = null;
            Toolkit.getDefaultToolkit().removeAWTEventListener(this._globalEnterExitListener);
            this._globalEnterExitListener = null;
            this.removeMouseListener(this._enterExitListener);
            this._enterExitListener = null;
        }
    }

    @Override
    public Color getForeground() {
        Color c = null;
        if (this._item != null) {
            c = this._renderer.getDisplayNameFgColor(this._item, this._item.isSelected(), this._isHovered);
        }
        return c != null ? c : super.getForeground();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this._renderer.paintBackground(this._item, g2D, this.getWidth(), this.getHeight(), this._isHovered);
        this._renderer.paintBorder(this._item, g2D, this.getWidth(), this.getHeight(), this._isHovered);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void setHovered(boolean hovered) {
        if (this._isHovered != hovered) {
            this._isHovered = hovered;
            this.repaint();
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private class DescriptionTextArea
    extends JTextArea {
        public DescriptionTextArea() {
            InputMap im = this.getInputMap();
            im.clear();
            ActionMap am = this.getActionMap();
            am.clear();
        }

        @Override
        public void scrollRectToVisible(Rectangle aRect) {
        }
    }

    private class EnterExitListener
    extends MouseAdapter {
        private EnterExitListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TreeListItemPanel.this.setHovered(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TreeListItemPanel.this.setHovered(false);
        }
    }

    private class EnterExitMouseHandler
    implements AWTEventListener {
        private EnterExitMouseHandler() {
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            MouseEvent m;
            if (e instanceof MouseEvent && ((m = (MouseEvent)e).getID() == 504 || m.getID() == 505 || m.getID() == 500)) {
                Point p = WindowPopupManager.adjustMouseEventLocation(m);
                Rectangle bounds = TreeListItemPanel.this.getBounds();
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, TreeListItemPanel.this);
                bounds.setLocation(location);
                TreeListItemPanel.this.setHovered(!TreeListItemPanel.this._isExpanding && bounds.contains(p));
            }
        }
    }

    class ExpandAction
    extends AbstractAction {
        ExpandAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeListItemPanel.this._item.setExpanded(!TreeListItemPanel.this._item.isExpanded());
        }
    }

    private class UpdateComponentsListener
    implements PropertyChangeListener {
        private UpdateComponentsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("childAdded".equals(evt.getPropertyName()) || "childRemoved".equals(evt.getPropertyName()) || "expandedChanged".equals(evt.getPropertyName())) {
                TreeListItemPanel.this.updateExpandButton();
            } else {
                TreeListItemPanel.this.updateComponents();
            }
        }
    }
}

