/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.output;

import com.paterva.maltego.util.output.FormatMessage;
import com.paterva.maltego.util.output.MessageChunk;
import com.paterva.maltego.util.output.MessageLinkListener;
import com.paterva.maltego.util.output.OutputMessage;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import org.openide.util.Exceptions;
import org.openide.windows.IOColorPrint;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class PrintMessage {
    public static synchronized void printMessage(OutputMessage message, Color color, InputOutput io, Color linkColor) throws IOException, NumberFormatException {
        List chunks = message.getChunks();
        chunks = FormatMessage.highlightUrls((List)chunks);
        try {
            for (MessageChunk chunk : chunks) {
                MessageLinkListener linkListener = chunk.getLinkListener();
                if (linkListener == null) {
                    IOColorPrint.print((InputOutput)io, (CharSequence)chunk.getText(), (Color)color);
                    continue;
                }
                LinkOutputListener outputListener = new LinkOutputListener(linkListener);
                IOColorPrint.print((InputOutput)io, (CharSequence)chunk.getText(), (OutputListener)outputListener, (boolean)false, (Color)linkColor);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class LinkOutputListener
    implements OutputListener {
        private MessageLinkListener _listener;

        public LinkOutputListener(MessageLinkListener listener) {
            this._listener = listener;
        }

        public void outputLineSelected(OutputEvent ev) {
            this._listener.linkSelected();
        }

        public void outputLineAction(OutputEvent ev) {
            this._listener.linkAction();
        }

        public void outputLineCleared(OutputEvent ev) {
            this._listener.linkCleared();
        }
    }
}

