/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.PasswordEditPanel;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;

public class PasswordEditController
extends ValidatingController<PasswordEditPanel> {
    public static final String PASSWORD = "password";
    private boolean _retype;

    public PasswordEditController(boolean retype) {
        this._retype = retype;
        this.setName("Enter Password");
    }

    @Override
    protected PasswordEditPanel createComponent() {
        PasswordEditPanel panel = new PasswordEditPanel(this._retype);
        panel.addChangeListener(this.changeListener());
        return panel;
    }

    @Override
    protected String getFirstError(PasswordEditPanel component) {
        if (this._retype && !component.isSame()) {
            return "Passwords not the same!";
        }
        String password = component.getPassword();
        if (StringUtilities.isNullOrEmpty((String)password)) {
            return "Password may not be empty";
        }
        return null;
    }

    @Override
    protected void readSettings(WizardDescriptor settings) {
        Object password;
        Object icon;
        Object description = settings.getProperty("password_description");
        if (description != null) {
            this.setDescription((String)description);
        }
        if ((icon = settings.getProperty("password_icon")) != null) {
            this.setImage(ImageUtilities.loadImage((String)((String)icon).replace(".png", "48.png")));
        }
        if ((password = settings.getProperty(PASSWORD)) instanceof String) {
            PasswordEditPanel panel = (PasswordEditPanel)this.getComponent();
            panel.setPassword((String)password);
        }
    }

    @Override
    protected void storeSettings(WizardDescriptor settings) {
        PasswordEditPanel panel = (PasswordEditPanel)this.getComponent();
        settings.putProperty(PASSWORD, (Object)panel.getPassword());
    }
}

