/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.painter.BusyPainter;

public class BusySpinnerPanel
extends JPanel {
    private final JPanel panel;

    public BusySpinnerPanel() {
        this(25);
    }

    public BusySpinnerPanel(int size) {
        this.setLayout(new BorderLayout());
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBackground(UIManager.getLookAndFeelDefaults().getColor("home-main-bg"));
        float factor = (float)size / 100.0f;
        JXBusyLabel label = new JXBusyLabel(new Dimension(size, size));
        BusyPainter painter = new BusyPainter(size);
        painter.setTrailLength(5);
        painter.setPoints(10);
        painter.setPointShape((Shape)new RoundRectangle2D.Float(10.0f * factor, 10.0f * factor, 50.0f * factor, 20.0f * factor, 20.0f * factor, 20.0f * factor));
        painter.setFrame(1);
        label.setPreferredSize(new Dimension(size, size));
        label.setIcon((Icon)new EmptyIcon(size, size));
        label.setBusyPainter(painter);
        label.setBusy(true);
        label.setHorizontalAlignment(0);
        this.panel.add((Component)label, "Center");
        this.panel.setAlignmentY(0.5f);
        this.add((Component)this.panel, "Center");
    }

    @Override
    public void setBackground(Color bg) {
        if (this.panel != null) {
            this.panel.setBackground(bg);
        }
    }
}

