/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.save;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.cloud.CloudGraph;
import com.maltego.cloud.crypto.GraphEncryptor;
import com.maltego.cloud.crypto.Pair;
import com.maltego.cloud.data.Case;
import com.maltego.cloud.data.CaseKey;
import com.maltego.cloud.data.GraphEncryptionConfig;
import com.maltego.cloud.rest.GraphStoreRestClient;
import com.maltego.cloud.serializer.NeoJsonAttachments;
import com.paterva.maltego.certificates.rest.MultipartWriter;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.util.FileStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.openide.awt.StatusDisplayer;

public abstract class CloudGraphSaveOperation {
    private static final Logger LOG = Logger.getLogger(CloudGraphSaveOperation.class.getName());
    protected CloudGraph cloudGraph;

    private CloudGraphSaveOperation(CloudGraph cloudGraph) {
        this.cloudGraph = cloudGraph;
    }

    public static CloudGraphSaveOperation create(CloudGraph cloudGraph) {
        Case cloudCase = cloudGraph.getCase();
        if (cloudCase.isEncrypted()) {
            return new Encrypted(cloudGraph);
        }
        return new Plain(cloudGraph);
    }

    public abstract void perform(String var1, Map<Guid, NeoJsonAttachments> var2, boolean var3) throws IOException, GeneralSecurityException;

    protected String getUploadFilename(String filename, int attNum) {
        String ext = FilenameUtils.getExtension((String)filename);
        if (!ext.isEmpty()) {
            ext = "." + ext;
        }
        return "att" + attNum + ext;
    }

    private static class Encrypted
    extends CloudGraphSaveOperation {
        private Encrypted(CloudGraph cloudGraph) {
            super(cloudGraph);
        }

        @Override
        public void perform(String graphJson, Map<Guid, NeoJsonAttachments> attachments, boolean isNewGraph) throws IOException, GeneralSecurityException {
            GraphEncryptionConfig graphEncryptionConfig;
            GraphEncryptor encryptor;
            Case cloudCase = this.cloudGraph.getCase();
            String cloudCaseId = cloudCase.getId().toString();
            CaseKey caseKey = GraphStoreRestClient.fetchCaseKey((String)cloudCaseId);
            if (isNewGraph) {
                encryptor = GraphEncryptor.forNewGraph((CaseKey)caseKey, (GraphID)this.cloudGraph.getMaltegoGraphID());
                this.cloudGraph.addToLookup((Object)encryptor);
                graphEncryptionConfig = GraphEncryptionConfig.createForNewGraph();
                this.cloudGraph.addToLookup((Object)graphEncryptionConfig);
            } else {
                encryptor = (GraphEncryptor)this.cloudGraph.getContentFromLookup(GraphEncryptor.class);
                GraphEncryptionConfig configForOldVersion = (GraphEncryptionConfig)this.cloudGraph.getContentFromLookup(GraphEncryptionConfig.class);
                this.cloudGraph.removeFromLookup((Object)configForOldVersion);
                graphEncryptionConfig = GraphEncryptionConfig.createForNewVersion((GraphEncryptionConfig)configForOldVersion);
                this.cloudGraph.addToLookup((Object)graphEncryptionConfig);
            }
            StatusDisplayer.getDefault().setStatusText("Encrypting cloud graph");
            Pair resultPair = encryptor.encryptGraphJson(graphEncryptionConfig, graphJson);
            String encryptedGraphJson = (String)resultPair.first();
            String messageAuthenticationJson = (String)resultPair.second();
            String graphKeyJson = new ObjectMapper().writeValueAsString((Object)encryptor.getGraphKeyMeta());
            List<EncryptedAttachment> encryptedAttachments = this.encryptAttachments(encryptor, graphEncryptionConfig, attachments);
            String graphName = this.cloudGraph.getName();
            String result = GraphStoreRestClient.createSendGraphWriter((boolean)isNewGraph, (String)this.cloudGraph.getMaltegoGraphID().toString(), writer -> {
                writer.queueGraph("graph", graphName + ".json", encryptedGraphJson);
                writer.queueJson("graphKey", graphKeyJson);
                writer.queueJson("messageAuthentication", messageAuthenticationJson);
                writer.queueText("caseId", cloudCaseId);
                for (EncryptedAttachment att : encryptedAttachments) {
                    writer.queueFileContent("attachments", att.getName(), att.getContent());
                }
                AtomicLong prevProgress = new AtomicLong(-1L);
                long totalBytes = writer.getTotalBytesToWrite();
                writer.setBytesWrittenCallback(bytesWritten -> {
                    long progressPercent = (int)(100L * bytesWritten / totalBytes);
                    if (progressPercent != prevProgress.getAndSet(progressPercent)) {
                        StatusDisplayer.getDefault().setStatusText("Save To Maltego Cases - " + progressPercent + "%");
                    }
                });
            });
            LOG.log(Level.FINE, "Result: {0}", result);
        }

        private List<EncryptedAttachment> encryptAttachments(GraphEncryptor encryptor, GraphEncryptionConfig graphEncryptionConfig, Map<Guid, NeoJsonAttachments> attachments) throws IOException, GeneralSecurityException {
            ArrayList<EncryptedAttachment> encryptedAttachments = new ArrayList<EncryptedAttachment>();
            for (NeoJsonAttachments atts : attachments.values()) {
                int attNum = atts.getFirstIndex();
                for (Attachment attachment : atts.getAttachments()) {
                    int id = attachment.getId();
                    File file = FileStore.getDefault().get(id);
                    Path filePath = file.toPath();
                    String filename = attachment.getFileName();
                    String uploadFilename = this.getUploadFilename(filename, attNum++);
                    byte[] fileContent = Files.readAllBytes(filePath);
                    byte[] encryptedFileContent = encryptor.encryptFileContent(graphEncryptionConfig, fileContent);
                    encryptedAttachments.add(new EncryptedAttachment(uploadFilename, encryptedFileContent));
                }
            }
            return encryptedAttachments;
        }

        private class EncryptedAttachment {
            private final String name;
            private final byte[] content;

            public EncryptedAttachment(String name, byte[] content) {
                this.name = name;
                this.content = content;
            }

            public String getName() {
                return this.name;
            }

            public byte[] getContent() {
                return this.content;
            }
        }
    }

    private static class Plain
    extends CloudGraphSaveOperation {
        private Plain(CloudGraph cloudGraph) {
            super(cloudGraph);
        }

        @Override
        public void perform(String graphJson, Map<Guid, NeoJsonAttachments> attachments, boolean isNewGraph) throws IOException, GeneralSecurityException {
            Case cloudCase = this.cloudGraph.getCase();
            String cloudCaseId = cloudCase.getId().toString();
            String graphName = this.cloudGraph.getName();
            String result = GraphStoreRestClient.createSendGraphWriter((boolean)isNewGraph, (String)this.cloudGraph.getMaltegoGraphID().toString(), writer -> {
                writer.queueGraph("graph", graphName + ".json", graphJson);
                writer.queueText("caseId", cloudCaseId);
                this.queueAttachments((MultipartWriter)writer, attachments);
                AtomicLong prevProgress = new AtomicLong(-1L);
                long totalBytes = writer.getTotalBytesToWrite();
                writer.setBytesWrittenCallback(bytesWritten -> {
                    long progressPercent = (int)(100L * bytesWritten / totalBytes);
                    if (progressPercent != prevProgress.getAndSet(progressPercent)) {
                        StatusDisplayer.getDefault().setStatusText("Save To Cloud - " + progressPercent + "%");
                    }
                });
            });
            LOG.log(Level.FINE, "Result: {0}", result);
        }

        private void queueAttachments(MultipartWriter writer, Map<Guid, NeoJsonAttachments> attachments) throws IOException {
            for (NeoJsonAttachments atts : attachments.values()) {
                int attNum = atts.getFirstIndex();
                for (Attachment attachment : atts.getAttachments()) {
                    int id = attachment.getId();
                    File file = FileStore.getDefault().get(id);
                    Path filePath = file.toPath();
                    String filename = attachment.getFileName();
                    String uploadFilename = this.getUploadFilename(filename, attNum++);
                    writer.queueFile("attachments", uploadFilename, filePath);
                }
            }
        }
    }
}

