/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.convert;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class TabularGraphImportOptions {
    private static final String SAMPLING_ENABLED = "samplingEnabled";
    private static final String SAMPLING_RATE = "samplingRate";
    private static final String IGNORE_BLANK_CELLS = "ignoreBlankCells";
    private static final String TRIM_VALUES = "trimValues";
    private static final String ENTITY_LIMIT_ENABLED = "entityLimitEnabled";
    private static final String ENTITY_LIMIT = "entityLimit";
    private static final String MERGE_LINKS = "mergeLinks";
    private static final Preferences PREFS = TabularGraphImportOptions.getPreferences();

    public static void setSamplingEnabled(boolean samplingEnabled) {
        PREFS.putBoolean(SAMPLING_ENABLED, samplingEnabled);
    }

    public static boolean isSamplingEnabled() {
        return PREFS.getBoolean(SAMPLING_ENABLED, false);
    }

    public static void setSamplingRate(int samplingRate) {
        PREFS.putInt(SAMPLING_RATE, samplingRate);
    }

    public static int getSamplingRate() {
        return PREFS.getInt(SAMPLING_RATE, 10);
    }

    public static void setBlankCellsIgnored(boolean blankCellsIgnored) {
        PREFS.putBoolean(IGNORE_BLANK_CELLS, blankCellsIgnored);
    }

    public static boolean isBlankCellsIgnored() {
        return PREFS.getBoolean(IGNORE_BLANK_CELLS, true);
    }

    public static void setTrimValues(boolean trimValues) {
        PREFS.putBoolean(TRIM_VALUES, trimValues);
    }

    public static boolean isTrimValues() {
        return PREFS.getBoolean(TRIM_VALUES, true);
    }

    public static void setEntityLimitEnabled(boolean limitEnabled) {
        PREFS.putBoolean(ENTITY_LIMIT_ENABLED, limitEnabled);
    }

    public static boolean isEntityLimitEnabled() {
        return PREFS.getBoolean(ENTITY_LIMIT_ENABLED, true);
    }

    public static void setEntityLimit(int limit) {
        PREFS.putInt(ENTITY_LIMIT, limit);
    }

    public static int getEntityLimit() {
        return PREFS.getInt(ENTITY_LIMIT, 10000);
    }

    public static void setMergeLinks(boolean mergeLinks) {
        PREFS.putBoolean(MERGE_LINKS, mergeLinks);
    }

    public static boolean isMergeLinks() {
        return PREFS.getBoolean(MERGE_LINKS, true);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(TabularGraphImportOptions.class);
    }
}

