/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;

public class DarculaRadioButtonUI
extends MetalRadioButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaRadioButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        LookAndFeel.installProperty(b, "opaque", Boolean.FALSE);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension preferredSize = super.getPreferredSize(c);
        if (preferredSize.width > 0 && (SystemInfo.isLinux || SystemInfo.isWindows)) {
            preferredSize.width += 10;
        }
        return preferredSize;
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c) {
        Graphics2D g = (Graphics2D)g2d;
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension size = c.getSize();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = c.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        int rad = 5;
        int x = iconRect.x + (rad - 1) / 2;
        int y = iconRect.y + (rad - 1) / 2;
        int w = iconRect.width - (rad + 5) / 2;
        int h = iconRect.height - (rad + 5) / 2;
        g.translate(x, y);
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g);
        boolean focus = b.hasFocus();
        g.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getLookAndFeelDefaults().getColor("RadioButton.darculaMod.iconBackgroundColor1"), 0.0f, c.getHeight(), UIManager.getLookAndFeelDefaults().getColor("RadioButton.darculaMod.iconBackgroundColor2")));
        g.fillOval(1, 2, w - 1, h - 1);
        if (focus) {
            // empty if block
        }
        if (b.isSelected()) {
            g.setPaint(UIManager.getLookAndFeelDefaults().getColor(b.isEnabled() ? "RadioButton.darculaMod.SelectedBorderColor" : "RadioButton.darculaMod.BorderDisabledColor"));
            g.drawOval(0, 1, w - 1, h - 1);
            boolean enabled = b.isEnabled();
            g.setColor(UIManager.getLookAndFeelDefaults().getColor(enabled ? "RadioButton.darcula.selectionEnabledColor" : "RadioButton.darcula.selectionDisabledColor"));
            g.fillOval(w / 2 - rad / 2, h / 2 - 1, rad, rad);
        } else {
            g.setPaint(UIManager.getLookAndFeelDefaults().getColor(b.isEnabled() ? "RadioButton.darculaMod.BorderColor" : "RadioButton.darculaMod.BorderDisabledColor"));
            g.drawOval(0, 1, w - 1, h - 1);
        }
        config.restore();
        g.translate(-x, -y);
        if (text != null) {
            GraphicsUtil.setupTextAntialiasing(g, c);
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                int mnemIndex = b.getDisplayedMnemonicIndex();
                if (model.isEnabled()) {
                    g.setColor(b.getForeground());
                } else {
                    g.setColor(this.getDisabledTextColor());
                }
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        c.setFont(((JRadioButton)c).getFont());
    }

    @Override
    public Icon getDefaultIcon() {
        return new IconUIResource(EmptyIcon.create(20));
    }
}

