/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.sets;

import com.paterva.maltego.discovery.DiscoveryContext;
import com.paterva.maltego.discovery.DiscoveryProvider;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.imex.sets.TransformSetImporter;
import com.paterva.maltego.transform.manager.imex.sets.TransformSetsDiscoveryItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransformSetDiscoveryProvider
implements DiscoveryProvider<TransformSetsDiscoveryItems> {
    private static final Logger LOG = Logger.getLogger(TransformSetDiscoveryProvider.class.getName());

    public void apply(TransformSetsDiscoveryItems sets) {
        DiscoveryContext ctx = sets.getContext();
        if (!sets.isTrimmed()) {
            sets = this.getNewAndMerged(sets);
        }
        TransformSetImporter importer = new TransformSetImporter();
        List<TransformSet> newSets = sets.getTransformSets();
        this.printSets(ctx, "sets applied", newSets);
        importer.applySets(newSets);
        TransformSetRepository.getDefault().removeEmptySets();
        this.printSets(ctx, "sets after", TransformSetRepository.getDefault().allSets());
    }

    public TransformSetsDiscoveryItems getNewAndMerged(TransformSetsDiscoveryItems items) {
        DiscoveryContext ctx = items.getContext();
        ArrayList<TransformSet> sets = new ArrayList<TransformSet>(items.getTransformSets());
        Set<String> transforms = this.getHubTransformNames(ctx);
        this.removeNonHubTransforms(transforms, sets);
        this.printSets(ctx, "sets trimmed", sets);
        List<TransformSet> newSets = this.getNewAndMerged(transforms, sets);
        this.printSets(ctx, "sets new & merged", sets);
        return new TransformSetsDiscoveryItems(this, newSets, ctx, true);
    }

    private List<TransformSet> getNewAndMerged(Set<String> transforms, List<TransformSet> sets) {
        ArrayList<TransformSet> newSets = new ArrayList<TransformSet>();
        TransformSetRepository repo = TransformSetRepository.getDefault();
        for (TransformSet set : sets) {
            TransformSet oldSet = repo.get(set.getName());
            TransformSet newSet = oldSet == null ? set : this.mergeSets(set, oldSet, transforms);
            if (newSet == null) continue;
            newSets.add(newSet);
        }
        return newSets;
    }

    private Set<String> getHubTransformNames(DiscoveryContext ctx) {
        String seedUrl = ctx.getSeedUrl();
        HubSeedRegistry hubRegistry = HubSeedRegistry.getDefault();
        HubSeedDescriptor hubSeed = hubRegistry.getHubSeed(seedUrl);
        if (hubSeed == null) {
            throw new IllegalStateException("Could not find hub item being discovered from: " + seedUrl);
        }
        Set<String> hubTransforms = this.toNamesOnly(hubRegistry.getTransforms(hubSeed));
        LOG.log(Level.FINER, "hubTransforms = {0}", hubTransforms);
        return hubTransforms;
    }

    private void removeNonHubTransforms(Set<String> hubTransforms, List<TransformSet> sets) {
        for (TransformSet set : sets) {
            this.retainTransforms(set, hubTransforms);
        }
    }

    private void retainTransforms(TransformSet set, Set<String> hubTransforms) {
        HashSet setTransforms = new HashSet(set.getAllTransforms());
        for (String setTransform : setTransforms) {
            if (hubTransforms.contains(setTransform)) continue;
            set.removeTransform(setTransform);
        }
    }

    private TransformSet mergeSets(TransformSet newSet, TransformSet oldSet, Set<String> transforms) {
        LinkedHashSet oldTransforms = new LinkedHashSet(oldSet.getAllTransforms());
        oldTransforms.removeAll(transforms);
        newSet.addAllTransforms(oldTransforms);
        if (!oldSet.isCustom() || !newSet.isCustom()) {
            boolean dirty = newSet.isDirty();
            newSet.setCustom(false);
            if (!dirty) {
                newSet.markClean();
            }
        }
        return newSet;
    }

    private Set<String> toNamesOnly(Set<TransformDefinition> transforms) {
        HashSet<String> names = new HashSet<String>(transforms.size());
        for (TransformDefinition transform : transforms) {
            names.add(transform.getName());
        }
        return names;
    }

    protected void printSets(DiscoveryContext ctx, String title, Collection<TransformSet> sets) {
        if (LOG.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder();
            sb.append(ctx.getSeedUrl()).append("\n").append(title).append(" = {\n");
            for (TransformSet set : sets) {
                sb.append("  {").append("\n");
                sb.append("     name: ").append(set.getName()).append("\n");
                sb.append("     description: ").append(set.getDescription()).append("\n");
                sb.append("     custom: ").append(set.isCustom()).append("\n");
                sb.append("     transforms: ").append(set.getAllTransforms()).append("\n");
                sb.append("  },").append("\n");
            }
            sb.append("}\n");
            LOG.finer(sb.toString());
        }
    }
}

