/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import com.paterva.maltego.util.IconSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.officelaf.ribbon.DiscreteResizableIcon;
import org.officelaf.ribbon.OfficeBackgroundHelper;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.RibbonBandUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class OfficeRibbonUI
extends BasicRibbonUI {
    protected BufferedImage taskBackgroundCache;
    protected JCommandButton minimizeButton;
    protected ResizableIcon minimizedIcon = new DiscreteResizableIcon("org/officelaf/ribbon/images/right_arrow.png");
    protected ResizableIcon restoredIcon = new DiscreteResizableIcon("org/officelaf/ribbon/images/down_arrow.png");
    protected PropertyChangeListener minimizeListener;
    private boolean blocklayout = false;
    private final MinimizeButtonListener minimizeButtonListener = new MinimizeButtonListener();
    private int taskToggleButtonHeight = -1;
    protected int tabSpacing = 1;

    public static ComponentUI createUI(JComponent c) {
        return new OfficeRibbonUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.ribbon.setOpaque(false);
    }

    protected void installComponents() {
        super.installComponents();
        this.ribbon.remove((Component)this.taskBarPanel);
        this.taskBarPanel = new TaskbarPanel();
        this.taskBarPanel.setName("JRibbon Task Bar");
        this.taskBarPanel.setLayout(this.createTaskbarLayoutManager());
        this.ribbon.add((Component)this.taskBarPanel);
        this.bandScrollablePanel.setOpaque(false);
        for (Component component : this.bandScrollablePanel.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setOpaque(false);
        }
        this.taskToggleButtonsScrollablePanel.setOpaque(false);
        for (Component component : this.taskToggleButtonsScrollablePanel.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setOpaque(false);
        }
        this.minimizeListener = new MinimizeListener();
        this.ribbon.addPropertyChangeListener(this.minimizeListener);
        this.minimizeButton = new JCommandButton("");
        this.minimizeButton.setDisplayState(CommandButtonDisplayState.SMALL);
        this.minimizeButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        this.minimizeButton.setActionRichTooltip(new RichTooltip("Collapse/expand ribbon", "Collapse or expand the ribbon bar. Also possible by double-clicking on one of the tabs."));
        this.minimizeButton.getActionModel().addActionListener((ActionListener)this.minimizeButtonListener);
        this.updateMinimizeButtonIcon();
        this.ribbon.add((Component)this.minimizeButton);
        this.ribbon.setOpaque(false);
    }

    protected void uninstallComponents() {
        this.minimizeButton.getActionModel().removeActionListener((ActionListener)this.minimizeButtonListener);
        this.ribbon.remove((Component)this.minimizeButton);
        this.ribbon.removePropertyChangeListener(this.minimizeListener);
        this.ribbon.remove((Component)this.taskBarPanel);
        super.uninstallComponents();
    }

    protected LayoutManager createTaskbarLayoutManager() {
        return new TaskbarLayout();
    }

    protected BasicRibbonUI.BandHostPanel createBandHostPanel() {
        return new OfficeBandHostPanel();
    }

    protected BasicRibbonUI.TaskToggleButtonsHostPanel createTaskToggleButtonsHostPanel() {
        return new OfficeTaskToggleButtonsHostPanel();
    }

    public int getTaskbarHeight() {
        return 28;
    }

    public int getTaskToggleButtonHeight() {
        int calcHeight = super.getTaskToggleButtonHeight();
        if (this.taskToggleButtonHeight == -1) {
            JButton tempButton = new JButton("Investigate");
            this.taskToggleButtonHeight = (int)tempButton.getPreferredSize().getHeight() - 2;
            this.taskToggleButtonHeight = Math.max(calcHeight, this.taskToggleButtonHeight);
        } else {
            calcHeight = this.taskToggleButtonHeight;
        }
        return calcHeight;
    }

    public static int getPaddingHeight() {
        int pad = UIManager.getLookAndFeelDefaults().getInt("SplitPane.dividerSize");
        if ((pad -= 3) < 0) {
            pad = 0;
        }
        return pad;
    }

    private void updateMinimizeButtonIcon() {
        if (this.minimizeButton != null) {
            this.minimizeButton.setIcon(this.ribbon.isMinimized() ? this.minimizedIcon : this.restoredIcon);
        }
    }

    public void paint(Graphics g, JComponent c) {
        this.paintBackground(g);
        Insets ins = c.getInsets();
        int extraHeight = this.getTaskToggleButtonHeight();
        if (!this.isUsingTitlePane()) {
            extraHeight += this.getTaskbarHeight();
        }
        this.paintTaskArea(g, 0, ins.top + (extraHeight += OfficeRibbonUI.getPaddingHeight()) - 1, c.getWidth(), c.getHeight() - extraHeight - ins.top);
    }

    protected void paintBackground(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Color background = UIManager.getLookAndFeelDefaults().getColor("ribbon-background-color");
        g2d.setColor(background);
        int y = this.getTaskbarHeight() + this.ribbon.getInsets().top - 1;
        g2d.fillRect(0, y, this.ribbon.getWidth(), this.ribbon.getHeight() - y);
    }

    protected void paintTaskArea(Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.taskBackgroundCache == null || width != this.taskBackgroundCache.getWidth() || height != this.taskBackgroundCache.getHeight()) {
            this.taskBackgroundCache = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            Graphics2D ig = this.taskBackgroundCache.createGraphics();
            OfficeBackgroundHelper.drawTaskAreaGradient(ig, width, height, false);
            ig.dispose();
        }
        g2d.drawImage((Image)this.taskBackgroundCache, x, y, null);
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonLayout();
    }

    private class MinimizeButtonListener
    implements ActionListener {
        private MinimizeButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OfficeRibbonUI.this.blocklayout = true;
            OfficeRibbonUI.this.ribbon.setMinimized(!OfficeRibbonUI.this.ribbon.isMinimized());
            OfficeRibbonUI.this.blocklayout = false;
        }
    }

    private class MinimizeListener
    implements PropertyChangeListener {
        private MinimizeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("minimized".equals(evt.getPropertyName())) {
                OfficeRibbonUI.this.updateMinimizeButtonIcon();
            }
        }
    }

    private class RibbonLayout
    implements LayoutManager {
        private RibbonLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int maxPrefBandHeight = 0;
            boolean isRibbonMinimized = OfficeRibbonUI.this.ribbon.isMinimized();
            if (!isRibbonMinimized && OfficeRibbonUI.this.ribbon.getTaskCount() > 0) {
                RibbonTask selectedTask = OfficeRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand ribbonBand : selectedTask.getBands()) {
                    int bandPrefHeight = ribbonBand.getPreferredSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    maxPrefBandHeight = Math.max(maxPrefBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
            }
            int extraHeight = OfficeRibbonUI.this.getTaskToggleButtonHeight();
            if (!OfficeRibbonUI.this.isUsingTitlePane()) {
                extraHeight += OfficeRibbonUI.this.getTaskbarHeight();
            }
            int prefHeight = maxPrefBandHeight + (extraHeight += OfficeRibbonUI.getPaddingHeight()) + ins.top + ins.bottom;
            return new Dimension(c.getWidth(), prefHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int width = 0;
            int maxMinBandHeight = 0;
            int gap = OfficeRibbonUI.this.getBandGap();
            int extraHeight = OfficeRibbonUI.this.getTaskToggleButtonHeight();
            if (!OfficeRibbonUI.this.isUsingTitlePane()) {
                extraHeight += OfficeRibbonUI.this.getTaskbarHeight();
            }
            extraHeight += OfficeRibbonUI.getPaddingHeight();
            if (OfficeRibbonUI.this.ribbon.getTaskCount() > 0) {
                boolean isRibbonMinimized = OfficeRibbonUI.this.ribbon.isMinimized();
                RibbonTask selectedTask = OfficeRibbonUI.this.ribbon.getSelectedTask();
                for (AbstractRibbonBand ribbonBand : selectedTask.getBands()) {
                    int bandPrefHeight = ribbonBand.getMinimumSize().height;
                    Insets bandInsets = ribbonBand.getInsets();
                    RibbonBandUI bandUI = ribbonBand.getUI();
                    width += bandUI.getPreferredCollapsedWidth();
                    if (isRibbonMinimized) continue;
                    maxMinBandHeight = Math.max(maxMinBandHeight, bandPrefHeight + bandInsets.top + bandInsets.bottom);
                }
                width += gap * (selectedTask.getBandCount() - 1);
            } else {
                width = 50;
            }
            return new Dimension(width, maxMinBandHeight + extraHeight + ins.top + ins.bottom);
        }

        @Override
        public void layoutContainer(Container c) {
            int taskButtonsWidth;
            Dimension preferred;
            if (OfficeRibbonUI.this.blocklayout) {
                return;
            }
            Insets ins = c.getInsets();
            int tabButtonGap = OfficeRibbonUI.this.getTabButtonGap();
            boolean ltr = OfficeRibbonUI.this.ribbon.getComponentOrientation().isLeftToRight();
            int width = c.getWidth();
            int taskbarHeight = OfficeRibbonUI.this.getTaskbarHeight();
            int y = ins.top;
            boolean isUsingTitlePane = OfficeRibbonUI.this.isUsingTitlePane();
            if (!isUsingTitlePane) {
                OfficeRibbonUI.this.taskBarPanel.removeAll();
                for (Component regComp : OfficeRibbonUI.this.ribbon.getTaskbarComponents()) {
                    OfficeRibbonUI.this.taskBarPanel.add(regComp);
                }
                OfficeRibbonUI.this.taskBarPanel.setBounds(ins.left, ins.top - 2, width - ins.left - ins.right, taskbarHeight);
                y += taskbarHeight;
            } else {
                OfficeRibbonUI.this.taskBarPanel.setBounds(0, 0, 0, 0);
            }
            int taskToggleButtonHeight = OfficeRibbonUI.this.getTaskToggleButtonHeight();
            int x = ltr ? ins.left : width - ins.right;
            int appMenuButtonSize = taskbarHeight + taskToggleButtonHeight;
            if (!isUsingTitlePane) {
                OfficeRibbonUI.this.applicationMenuButton.setVisible(OfficeRibbonUI.this.ribbon.getApplicationMenu() != null);
                if (OfficeRibbonUI.this.ribbon.getApplicationMenu() != null) {
                    if (ltr) {
                        OfficeRibbonUI.this.applicationMenuButton.setBounds(x, ins.top, appMenuButtonSize, appMenuButtonSize);
                    } else {
                        OfficeRibbonUI.this.applicationMenuButton.setBounds(x - appMenuButtonSize, ins.top, appMenuButtonSize, appMenuButtonSize);
                    }
                }
            } else {
                OfficeRibbonUI.this.applicationMenuButton.setVisible(false);
            }
            int n = x = ltr ? x + 2 : x - 2;
            if (FlamingoUtilities.getApplicationMenuButton((Component)SwingUtilities.getWindowAncestor((Component)OfficeRibbonUI.this.ribbon)) != null) {
                x = ltr ? x + appMenuButtonSize : x - appMenuButtonSize;
            }
            y += OfficeRibbonUI.getPaddingHeight();
            if (OfficeRibbonUI.this.helpButton != null) {
                preferred = OfficeRibbonUI.this.helpButton.getPreferredSize();
                if (ltr) {
                    int helpX = width - ins.right - preferred.width;
                    OfficeRibbonUI.this.helpButton.setBounds(helpX, y, preferred.width, preferred.height);
                } else {
                    OfficeRibbonUI.this.helpButton.setBounds(ins.left, y, preferred.width, preferred.height);
                }
            }
            if (OfficeRibbonUI.this.licenseButton != null) {
                int iconSize = IconSize.TINY.getSize();
                Dimension helpSize = OfficeRibbonUI.this.helpButton != null ? OfficeRibbonUI.this.helpButton.getPreferredSize() : new Dimension(8 + iconSize, 5 + iconSize);
                Dimension preferred2 = OfficeRibbonUI.this.licenseButton.getPreferredSize();
                if (OfficeRibbonUI.this.helpButton != null) {
                    Dimension size = new Dimension(preferred2.width, helpSize.height);
                    OfficeRibbonUI.this.licenseButton.setPreferredSize(size);
                    preferred2 = size;
                }
                int helpX = width - ins.right - helpSize.width;
                if (ltr) {
                    OfficeRibbonUI.this.licenseButton.setBounds(helpX - preferred2.width, y, preferred2.width, preferred2.height);
                } else {
                    OfficeRibbonUI.this.licenseButton.setBounds(ins.left + helpSize.width, y, preferred2.width, preferred2.height);
                }
            }
            if (OfficeRibbonUI.this.minimizeButton != null) {
                preferred = OfficeRibbonUI.this.minimizeButton.getPreferredSize();
                if (ltr) {
                    int minimizeButtonX = x;
                    OfficeRibbonUI.this.minimizeButton.setBounds(minimizeButtonX, y, preferred.width, preferred.height);
                    x += preferred.width;
                } else {
                    OfficeRibbonUI.this.minimizeButton.setBounds(ins.left, y, preferred.width, preferred.height);
                }
            }
            if (ltr) {
                taskButtonsWidth = OfficeRibbonUI.this.licenseButton != null ? OfficeRibbonUI.this.licenseButton.getX() - tabButtonGap - x : (OfficeRibbonUI.this.helpButton != null ? OfficeRibbonUI.this.helpButton.getX() - tabButtonGap - x : c.getWidth() - ins.right - x);
                OfficeRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(x, y, taskButtonsWidth, taskToggleButtonHeight);
            } else {
                taskButtonsWidth = OfficeRibbonUI.this.licenseButton != null ? x - tabButtonGap - OfficeRibbonUI.this.licenseButton.getX() - OfficeRibbonUI.this.licenseButton.getWidth() : (OfficeRibbonUI.this.helpButton != null ? x - tabButtonGap - OfficeRibbonUI.this.helpButton.getX() - OfficeRibbonUI.this.helpButton.getWidth() : x - ins.left);
                OfficeRibbonUI.this.taskToggleButtonsScrollablePanel.setBounds(x - taskButtonsWidth, y, taskButtonsWidth, taskToggleButtonHeight);
            }
            BasicRibbonUI.TaskToggleButtonsHostPanel taskToggleButtonsHostPanel = (BasicRibbonUI.TaskToggleButtonsHostPanel)OfficeRibbonUI.this.taskToggleButtonsScrollablePanel.getView();
            int taskToggleButtonsHostPanelMinWidth = taskToggleButtonsHostPanel.getMinimumSize().width;
            taskToggleButtonsHostPanel.setPreferredSize(new Dimension(taskToggleButtonsHostPanelMinWidth, ((OfficeRibbonUI)OfficeRibbonUI.this).taskToggleButtonsScrollablePanel.getBounds().height));
            OfficeRibbonUI.this.taskToggleButtonsScrollablePanel.doLayout();
            y += taskToggleButtonHeight;
            int extraHeight = taskToggleButtonHeight;
            if (!isUsingTitlePane) {
                extraHeight += taskbarHeight;
            }
            extraHeight += OfficeRibbonUI.getPaddingHeight();
            if (OfficeRibbonUI.this.bandScrollablePanel.getParent() == OfficeRibbonUI.this.ribbon) {
                if (!OfficeRibbonUI.this.ribbon.isMinimized() && OfficeRibbonUI.this.ribbon.getTaskCount() > 0) {
                    Insets bandInsets = OfficeRibbonUI.this.ribbon.getSelectedTask().getBandCount() == 0 ? new Insets(0, 0, 0, 0) : OfficeRibbonUI.this.ribbon.getSelectedTask().getBand(0).getInsets();
                    OfficeRibbonUI.this.bandScrollablePanel.setBounds(1 + ins.left, y + bandInsets.top, c.getWidth() - 2 * ins.left - 2 * ins.right - 1, c.getHeight() - extraHeight - ins.top - ins.bottom - bandInsets.top - bandInsets.bottom);
                    BasicRibbonUI.BandHostPanel bandHostPanel = (BasicRibbonUI.BandHostPanel)OfficeRibbonUI.this.bandScrollablePanel.getView();
                    int bandHostPanelMinWidth = bandHostPanel.getMinimumSize().width;
                    bandHostPanel.setPreferredSize(new Dimension(bandHostPanelMinWidth, ((OfficeRibbonUI)OfficeRibbonUI.this).bandScrollablePanel.getBounds().height));
                    OfficeRibbonUI.this.bandScrollablePanel.doLayout();
                    bandHostPanel.doLayout();
                } else {
                    OfficeRibbonUI.this.bandScrollablePanel.setBounds(0, 0, 0, 0);
                }
            }
        }
    }

    protected class OfficeBandHostPanel
    extends BasicRibbonUI.BandHostPanel {
        public OfficeBandHostPanel() {
            this.setOpaque(false);
        }
    }

    protected class OfficeTaskToggleButtonsHostPanel
    extends BasicRibbonUI.TaskToggleButtonsHostPanel {
        public OfficeTaskToggleButtonsHostPanel() {
            super((BasicRibbonUI)OfficeRibbonUI.this);
            this.setOpaque(false);
        }
    }

    private class TaskbarLayout
    implements LayoutManager {
        private TaskbarLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Insets ins = c.getInsets();
            int pw = 0;
            int gap = OfficeRibbonUI.this.getBandGap();
            for (Component regComp : OfficeRibbonUI.this.ribbon.getTaskbarComponents()) {
                pw += regComp.getPreferredSize().width;
                pw += gap;
            }
            return new Dimension(pw + ins.left + ins.right, OfficeRibbonUI.this.getTaskbarHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets ins = c.getInsets();
            int gap = OfficeRibbonUI.this.getBandGap();
            int x = ins.left + 1 + OfficeRibbonUI.this.applicationMenuButton.getX() + OfficeRibbonUI.this.applicationMenuButton.getWidth();
            for (Component regComp : OfficeRibbonUI.this.ribbon.getTaskbarComponents()) {
                int pw = regComp.getPreferredSize().width;
                regComp.setBounds(x, 2, pw, c.getHeight() - ins.top - ins.bottom - 4);
                x += pw + gap;
            }
        }
    }

    private class TaskbarPanel
    extends JPanel {
        public TaskbarPanel() {
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        @Override
        protected void paintComponent(Graphics g) {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            return new Dimension(result.width + result.height / 2, result.height);
        }
    }
}

