/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.manager;

import com.paterva.maltego.licensing.C;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.LicenseDateFormat;
import com.paterva.maltego.licensing.UserInfo;
import com.paterva.maltego.licensing.free.A;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import com.paterva.maltego.licensing.ui.action.MaltegoIdLogoutAction;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MaltegoIdPanel
extends JPanel {
    private final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final JButton closeButton;
    private final Color errorDarkColor;
    private boolean logIn = false;
    private boolean logInAndActivate = false;
    private boolean switchOrg = false;
    private boolean gatewayMaltegoId = false;
    private RequestProcessor requestProcessor;
    private JButton comparePlansButton;
    private JButton copyLogoutUrlButton;
    private JButton copyProfileUrlButton;
    private JLabel currentPlanLabel;
    private JTextArea descriptionTextArea;
    private JLabel fullNameLabel;
    private JTextField fullNameTextField;
    private JTextField fullNameTextField1;
    private JButton goToProfileButton;
    private JLabel invalidLabel;
    private JButton logInButton;
    private JButton logoutButton;
    private JTextField logoutUrlTextField;
    private JLabel organizationLabel;
    private JPanel organizationPanel;
    private JPanel plansPanel;
    private JPanel profilePanel;
    private JTextField profileUrlTextField;
    private JButton switchOrganizationButton;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JPanel userLoginPanel;
    private JLabel validUntilLabel;
    private JPanel validUntilPanel;
    private JTextField validUntilTextField;

    public MaltegoIdPanel(com.paterva.maltego.licensing.mode.A licenseMode, JButton closeButton) {
        Boolean disabledBorderEmpty;
        this.closeButton = closeButton;
        this.initComponents();
        Color orange = this.LAF.getColor("3-maltego-orange");
        this.titleLabel.setForeground(orange);
        this.descriptionTextArea.setForeground(orange);
        this.titlePanel.setBackground(this.LAF.getColor("7-heading-panel-background"));
        Color disabledBg = this.LAF.getColor("license-panel-textfield-disabled-bg");
        if (disabledBg == null) {
            disabledBg = new JPanel().getBackground();
        }
        this.fullNameTextField.setBackground(disabledBg);
        this.validUntilTextField.setBackground(disabledBg);
        this.logoutUrlTextField.setBackground(disabledBg);
        this.profileUrlTextField.setBackground(disabledBg);
        Color disabledFg = this.LAF.getColor("license-panel-textfield-disabled-fg");
        if (disabledFg != null) {
            this.fullNameTextField.setForeground(disabledFg);
            this.validUntilTextField.setForeground(disabledFg);
            this.logoutUrlTextField.setBackground(disabledBg);
            this.profileUrlTextField.setBackground(disabledBg);
        }
        if (Boolean.TRUE.equals(disabledBorderEmpty = Boolean.valueOf(this.LAF.getBoolean("license-panel-textfield-disabled-border-empty")))) {
            EmptyBorder emptyBorder = new EmptyBorder(6, 8, 6, 8);
            this.fullNameTextField.setBorder(emptyBorder);
            this.validUntilTextField.setBorder(emptyBorder);
            this.logoutUrlTextField.setBorder(emptyBorder);
            this.profileUrlTextField.setBorder(emptyBorder);
        }
        this.errorDarkColor = this.LAF.getColor("7-dark-red");
        this.invalidLabel.setForeground(this.errorDarkColor);
        this.adjustForLicenseMode(licenseMode);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.requestProcessor = new RequestProcessor("AccountDetails", 1, true, true);
    }

    @Override
    public void removeNotify() {
        this.requestProcessor.shutdownNow();
        this.requestProcessor = null;
        super.removeNotify();
    }

    public boolean isLogIn() {
        return this.logIn;
    }

    public boolean isLogInAndActivate() {
        return this.logInAndActivate;
    }

    public boolean isSwitchOrg() {
        return this.switchOrg;
    }

    private void adjustForLicenseMode(com.paterva.maltego.licensing.mode.A licenseMode) {
        this.gatewayMaltegoId = licenseMode.U();
        boolean online = licenseMode.I();
        this.titleLabel.setText(online ? "Maltego Community Edition" : "Maltego CaseFile");
        this.logInButton.setVisible(false);
        this.validUntilPanel.setVisible(false);
        this.descriptionTextArea.setVisible(false);
        if (this.gatewayMaltegoId) {
            C validity = licenseMode.R();
            E capability = validity.J();
            String beta = MaltegoIdProductRestrictions.isInBeta((com.paterva.maltego.licensing.mode.A)licenseMode) ? " Beta" : "";
            this.titleLabel.setText(capability.F() + beta + " \u00b7 " + capability.A());
            this.descriptionTextArea.setVisible(true);
            UserInfo userInfo = new UserInfo(licenseMode);
            if (userInfo.isEmailUser()) {
                this.fullNameTextField.setText(userInfo.getFullName());
            } else {
                this.fullNameTextField.setText(userInfo.getUsername());
            }
            if (userInfo.getOrganization().isEmpty()) {
                this.organizationPanel.setVisible(false);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(userInfo.getOrganization());
                String region = userInfo.getRegion();
                if (!region.isEmpty()) {
                    sb.append("  (Region: ").append(region).append(")");
                }
                this.organizationLabel.setText(sb.toString());
            }
            this.currentPlanLabel.setText(userInfo.getCurrentPlan());
            this.profileUrlTextField.setText(MaltegoUrl.getCurrent().getGotoMaltegoIDProfile());
            this.profileUrlTextField.setCaretPosition(0);
            boolean beforeFrom = !validity.L();
            boolean afterTo = validity.M();
            this.invalidLabel.setVisible(beforeFrom || afterTo);
            this.invalidLabel.setText(beforeFrom ? "(License not yet valid)" : "(License Expired!)");
            long daysRemaining = validity.H();
            if (!afterTo && !beforeFrom) {
                this.descriptionTextArea.setText("Your license is still valid for " + daysRemaining + " days.");
                this.descriptionTextArea.setForeground(this.titleLabel.getForeground());
                this.validUntilPanel.setVisible(true);
                long validTo = capability.G();
                this.validUntilTextField.setText(LicenseDateFormat.format((long)validTo));
            } else if (beforeFrom) {
                String description = "Your license is not yet valid.";
                this.descriptionTextArea.setText(description);
                this.descriptionTextArea.setForeground(this.errorDarkColor);
            } else {
                boolean isInGracePeriod = validity.A();
                String description = "Your license expired " + Math.abs(daysRemaining) + " days ago. Please renew your license.";
                if (isInGracePeriod) {
                    long graceDays = validity.D();
                    description = description + " You have a grace period of " + graceDays + " days left.";
                }
                this.descriptionTextArea.setText(description);
                this.descriptionTextArea.setForeground(this.errorDarkColor);
            }
        } else if (online) {
            UserInfo userInfo = new UserInfo(licenseMode);
            long validTo = A.R();
            if (validTo >= System.currentTimeMillis()) {
                if (userInfo.isEmailUser()) {
                    this.fullNameTextField.setText(userInfo.getFullName());
                } else {
                    this.fullNameTextField.setText(userInfo.getUsername());
                }
                this.validUntilTextField.setText(LicenseDateFormat.format((long)validTo));
                this.logInButton.setVisible(false);
            } else {
                this.fullNameLabel.setVisible(false);
                this.fullNameTextField.setVisible(false);
                this.logInButton.setVisible(true);
            }
        } else {
            this.userLoginPanel.setVisible(false);
            this.profilePanel.setVisible(false);
            this.organizationPanel.setVisible(false);
            this.plansPanel.setVisible(false);
        }
    }

    private void initComponents() {
        this.fullNameTextField1 = new JTextField();
        this.logoutUrlTextField = new JTextField();
        this.copyLogoutUrlButton = new JButton();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.invalidLabel = new JLabel();
        this.descriptionTextArea = new JTextArea();
        this.userLoginPanel = new JPanel();
        this.fullNameLabel = new JLabel();
        this.fullNameTextField = new JTextField();
        this.logInButton = new JButton();
        this.logoutButton = new JButton();
        this.organizationPanel = new JPanel();
        this.organizationLabel = new JLabel();
        this.switchOrganizationButton = new JButton();
        this.plansPanel = new JPanel();
        this.comparePlansButton = new JButton();
        this.currentPlanLabel = new JLabel();
        this.validUntilPanel = new JPanel();
        this.validUntilLabel = new JLabel();
        this.validUntilTextField = new JTextField();
        this.profilePanel = new JPanel();
        this.profileUrlTextField = new JTextField();
        this.copyProfileUrlButton = new JButton();
        this.goToProfileButton = new JButton();
        this.fullNameTextField1.setEditable(false);
        this.logoutUrlTextField.setEditable(false);
        this.logoutUrlTextField.setEnabled(false);
        this.copyLogoutUrlButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/copy.png")));
        this.copyLogoutUrlButton.setToolTipText(NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.copyLogoutUrlButton.toolTipText"));
        this.copyLogoutUrlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoIdPanel.this.copyLogoutUrlButtonActionPerformed(evt);
            }
        });
        this.setOpaque(false);
        this.titlePanel.setLayout(new GridBagLayout());
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(this.titleLabel.getFont().getStyle() | 1, this.titleLabel.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.titleLabel, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.titleLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.titlePanel.add((Component)this.titleLabel, gridBagConstraints);
        this.invalidLabel.setFont(this.invalidLabel.getFont().deriveFont(this.invalidLabel.getFont().getStyle() | 1, this.invalidLabel.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.invalidLabel, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.invalidLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.titlePanel.add((Component)this.invalidLabel, gridBagConstraints);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setText(NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.descriptionTextArea.text"));
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.titlePanel.add((Component)this.descriptionTextArea, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.fullNameLabel, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.fullNameLabel.text"));
        this.fullNameTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.logInButton, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.logInButton.text"));
        this.logInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoIdPanel.this.logInButtonActionPerformed(evt);
            }
        });
        this.logoutButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browse.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.logoutButton, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.logoutButton.text"));
        this.logoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoIdPanel.this.logoutButtonActionPerformed(evt);
            }
        });
        GroupLayout userLoginPanelLayout = new GroupLayout(this.userLoginPanel);
        this.userLoginPanel.setLayout(userLoginPanelLayout);
        userLoginPanelLayout.setHorizontalGroup(userLoginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userLoginPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fullNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fullNameTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logInButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logoutButton).addContainerGap()));
        userLoginPanelLayout.setVerticalGroup(userLoginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userLoginPanelLayout.createSequentialGroup().addContainerGap().addGroup(userLoginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.logoutButton, -1, -1, Short.MAX_VALUE).addComponent(this.fullNameTextField, -2, -1, -2).addComponent(this.fullNameLabel, -1, -1, Short.MAX_VALUE).addComponent(this.logInButton, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.organizationPanel.setMinimumSize(new Dimension(0, 40));
        Mnemonics.setLocalizedText((JLabel)this.organizationLabel, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.organizationLabel.text"));
        this.organizationLabel.setToolTipText(NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.organizationLabel.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.switchOrganizationButton, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.switchOrganizationButton.text"));
        this.switchOrganizationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoIdPanel.this.switchOrganizationButtonActionPerformed(evt);
            }
        });
        GroupLayout organizationPanelLayout = new GroupLayout(this.organizationPanel);
        this.organizationPanel.setLayout(organizationPanelLayout);
        organizationPanelLayout.setHorizontalGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(organizationPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.organizationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.switchOrganizationButton).addContainerGap()));
        organizationPanelLayout.setVerticalGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(organizationPanelLayout.createSequentialGroup().addContainerGap().addGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.organizationLabel).addComponent(this.switchOrganizationButton)).addContainerGap()));
        this.plansPanel.setMinimumSize(new Dimension(0, 40));
        this.comparePlansButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browse.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.comparePlansButton, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.comparePlansButton.text"));
        this.comparePlansButton.setToolTipText(NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.comparePlansButton.toolTipText"));
        this.comparePlansButton.setIconTextGap(6);
        this.comparePlansButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoIdPanel.this.comparePlansButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.currentPlanLabel, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.currentPlanLabel.text"));
        GroupLayout plansPanelLayout = new GroupLayout(this.plansPanel);
        this.plansPanel.setLayout(plansPanelLayout);
        plansPanelLayout.setHorizontalGroup(plansPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plansPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.currentPlanLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.comparePlansButton).addContainerGap()));
        plansPanelLayout.setVerticalGroup(plansPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plansPanelLayout.createSequentialGroup().addContainerGap().addGroup(plansPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.comparePlansButton, -1, -1, Short.MAX_VALUE).addComponent(this.currentPlanLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.validUntilPanel.setMinimumSize(new Dimension(0, 40));
        Mnemonics.setLocalizedText((JLabel)this.validUntilLabel, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.validUntilLabel.text"));
        this.validUntilTextField.setEditable(false);
        GroupLayout validUntilPanelLayout = new GroupLayout(this.validUntilPanel);
        this.validUntilPanel.setLayout(validUntilPanelLayout);
        validUntilPanelLayout.setHorizontalGroup(validUntilPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(validUntilPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.validUntilLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.validUntilTextField).addContainerGap()));
        validUntilPanelLayout.setVerticalGroup(validUntilPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(validUntilPanelLayout.createSequentialGroup().addContainerGap().addGroup(validUntilPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.validUntilLabel, -2, 23, -2).addComponent(this.validUntilTextField, -2, -1, -2)).addContainerGap()));
        this.profilePanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.profilePanel.setMinimumSize(new Dimension(0, 40));
        this.profileUrlTextField.setEditable(false);
        this.profileUrlTextField.setEnabled(false);
        this.copyProfileUrlButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/copy.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.copyProfileUrlButton, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.copyProfileUrlButton.text"));
        this.copyProfileUrlButton.setToolTipText(NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.copyProfileUrlButton.toolTipText"));
        this.copyProfileUrlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoIdPanel.this.copyProfileUrlButtonActionPerformed(evt);
            }
        });
        this.goToProfileButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browse.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.goToProfileButton, (String)NbBundle.getMessage(MaltegoIdPanel.class, (String)"MaltegoIdPanel.goToProfileButton.text"));
        this.goToProfileButton.setIconTextGap(6);
        this.goToProfileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MaltegoIdPanel.this.goToProfileButtonActionPerformed(evt);
            }
        });
        GroupLayout profilePanelLayout = new GroupLayout(this.profilePanel);
        this.profilePanel.setLayout(profilePanelLayout);
        profilePanelLayout.setHorizontalGroup(profilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(profilePanelLayout.createSequentialGroup().addComponent(this.profileUrlTextField).addGap(0, 0, 0).addComponent(this.copyProfileUrlButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.goToProfileButton)));
        profilePanelLayout.setVerticalGroup(profilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(profilePanelLayout.createSequentialGroup().addGroup(profilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.profileUrlTextField, -2, -1, -2).addComponent(this.copyProfileUrlButton).addComponent(this.goToProfileButton)).addGap(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titlePanel, -1, -1, Short.MAX_VALUE).addComponent(this.userLoginPanel, -1, -1, Short.MAX_VALUE).addComponent(this.organizationPanel, -1, -1, Short.MAX_VALUE).addComponent(this.plansPanel, -1, -1, Short.MAX_VALUE).addComponent(this.profilePanel, -1, -1, Short.MAX_VALUE).addComponent(this.validUntilPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.titlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userLoginPanel, -2, -1, -2).addGap(1, 1, 1).addComponent(this.organizationPanel, -2, -1, -2).addGap(1, 1, 1).addComponent(this.plansPanel, -2, -1, -2).addGap(1, 1, 1).addComponent(this.validUntilPanel, -2, -1, -2).addGap(1, 1, 1).addComponent(this.profilePanel, -2, -1, -2).addGap(0, 0, 0)));
    }

    private void logInButtonActionPerformed(ActionEvent evt) {
        this.logInAndActivate = this.gatewayMaltegoId;
        this.logIn = !this.logInAndActivate;
        this.closeButton.doClick();
    }

    private void comparePlansButtonActionPerformed(ActionEvent evt) {
        BrowseToUrl.compareProducts(null);
    }

    private void logoutButtonActionPerformed(ActionEvent evt) {
        Window ownerFrame = SwingUtilities.getWindowAncestor(this);
        MaltegoIdLogoutAction.getInstance().logout(this.requestProcessor, ownerFrame, this.closeButton, null);
    }

    private void goToProfileButtonActionPerformed(ActionEvent evt) {
        BrowseToUrl.go(MaltegoUrl.getCurrent().getGotoMaltegoIDProfile());
    }

    private void copyLogoutUrlButtonActionPerformed(ActionEvent evt) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.logoutUrlTextField.getText()), null);
    }

    private void copyProfileUrlButtonActionPerformed(ActionEvent evt) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.profileUrlTextField.getText()), null);
    }

    private void switchOrganizationButtonActionPerformed(ActionEvent evt) {
        this.switchOrg = true;
        this.closeButton.doClick();
    }
}

