/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.action.LicenseManagerAction;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.pinkmatter.api.flamingo.ResizableIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.pushingpixels.flamingo.api.common.LicenseActionListener;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public final class CheckLicenseAction
implements LicenseActionListener {
    private static final String INFINITY = "\u221e";
    private static final int ICON_SIZE_SMALL_24 = IconSize.SMALL.getSize();
    private final UIDefaults laf = UIManager.getLookAndFeelDefaults();
    private Date validUntil = null;
    private boolean isLicensed;
    private boolean isMaltegoIdLicensed;
    private Runnable licenseChangedCallback = () -> {};

    public CheckLicenseAction() {
        LicenseManager.A().A(event -> this.update());
        this.update();
    }

    private void update() {
        A licenseMode = LicenseManager.A().A(false);
        this.isLicensed = licenseMode.B();
        this.isMaltegoIdLicensed = licenseMode.W();
        this.validUntil = this.isLicensed ? new Date(licenseMode.J().J().G()) : (this.isMaltegoIdLicensed ? new Date(licenseMode.R().J().G()) : null);
        this.licenseChangedCallback.run();
    }

    public static long betweenDates(Date firstDate, Date secondDate) {
        return ChronoUnit.DAYS.between(firstDate.toInstant(), secondDate.toInstant());
    }

    public void setLicenseChangedCallback(Runnable licenseChangedCallback) {
        if (licenseChangedCallback == null) {
            licenseChangedCallback = () -> {};
        }
        this.licenseChangedCallback = licenseChangedCallback;
    }

    public String getTooltipText() {
        if (this.isMaltegoIdLicensed) {
            return "Account Details";
        }
        return "Number of license days remaining (Click for details)";
    }

    public ResizableIcon getIcon() {
        String text;
        if (this.isMaltegoIdLicensed) {
            ImageIcon keyIcon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/licensing/ui/resources/Account.png", (boolean)true);
            return ResizableIcons.binary((Icon)keyIcon, (Icon)keyIcon);
        }
        Long daysLeft = null;
        if (this.isLicensed) {
            daysLeft = CheckLicenseAction.betweenDates(new Date(), this.validUntil);
        }
        String string = text = !this.isLicensed ? INFINITY : Long.toString(daysLeft);
        Color iconColor = !this.isLicensed ? this.laf.getColor("check-license-icon-white") : (daysLeft > 30L ? this.laf.getColor("check-license-icon-gray") : (daysLeft > 10L ? this.laf.getColor("check-license-icon-orange") : this.laf.getColor("check-license-icon-red")));
        JLabel label = new JLabel();
        Font font = label.getFont();
        font = font.deriveFont(1);
        int iconWidth = ICON_SIZE_SMALL_24;
        CheckLicenseIcon icon = new CheckLicenseIcon(iconWidth, ICON_SIZE_SMALL_24, text, iconColor, this.getFontColour(), font);
        return icon;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public Color getFontColour() {
        String colorName = this.isLicensed ? "check-license-icon-white" : "check-license-icon-gray";
        return this.laf.getColor(colorName);
    }

    public void actionPerformed(ActionEvent e) {
        LicenseManagerAction action = (LicenseManagerAction)SystemAction.get(LicenseManagerAction.class);
        action.actionPerformed(null);
    }

    static /* synthetic */ int access$000() {
        return ICON_SIZE_SMALL_24;
    }

    private class CheckLicenseIcon
    implements ResizableIcon {
        private Icon _icon;
        private Color _bg = Color.yellow;
        private int _width = CheckLicenseAction.access$000();
        private int _height = CheckLicenseAction.access$000();
        private String _text = "?";
        private Color _fontColor = Color.black;
        private Font _font = new JLabel().getFont().deriveFont(1);

        private CheckLicenseIcon() {
            this._icon = GraphicsUtils.getCheckLicenseIcon((int)this._width, (int)this._height, (String)this._text, (Color)this._bg, (Color)this._fontColor, (Font)this._font);
        }

        public CheckLicenseIcon(int width, int height, String text, Color background, Color fontColor, Font font) {
            this._bg = background;
            this._width = width;
            this._height = height;
            this._text = text;
            this._fontColor = fontColor;
            this._font = font;
            this._icon = GraphicsUtils.getCheckLicenseIcon((int)this._width, (int)this._height, (String)this._text, (Color)this._bg, (Color)this._fontColor, (Font)this._font);
        }

        public void setDimension(Dimension newDimension) {
            this._width = newDimension.width;
            this._height = newDimension.height;
            this._icon = GraphicsUtils.getCheckLicenseIcon((int)this._width, (int)this._height, (String)this._text, (Color)this._bg, (Color)this._fontColor, (Font)this._font);
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this._icon.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return this._icon.getIconWidth();
        }

        public int getIconHeight() {
            return this._icon.getIconHeight();
        }
    }
}

