/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball.customization;

import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.view.ball.BallProperties;
import com.paterva.maltego.view.customization.api.Customizable;
import yguard.A.A.Y;
import yguard.A.J.BA;
import yguard.A.J.SA;

public class BallSizeCustomizable
extends Customizable.Nodes {
    public static final double MIN = 50.0;
    public static final double MAX = 500.0;
    public static final double DEFAULT = 100.0;

    public String getName() {
        return "maltego.view.customizable.node.ballsize";
    }

    public String getDisplayName() {
        return "Ball Size";
    }

    public String getDescription() {
        return "The entity ball size. Value is clamped to [50.0 - 500.0]. Default/fallback is 100.0.";
    }

    public boolean isViewSupported(String viewID) {
        return "BallView".equals(viewID);
    }

    public Class getValueType() {
        return Double.class;
    }

    public void setDefault(Y target) {
        this.setValue(target, (Object)null);
    }

    public Object getValue(Y target) {
        return BallProperties.getBallSize(target);
    }

    public void setValue(Y target, Object value) {
        BA realizer;
        double size = 100.0;
        if (value instanceof Number) {
            size = ((Number)value).doubleValue();
            size = Math.max(size, 50.0);
            size = Math.min(size, 500.0);
        }
        if (!Double.isInfinite(size) && !Double.isNaN(size)) {
            BallProperties.setBallSize(target, size);
        }
        if ((realizer = ((SA)target.H()).f(target)) instanceof LightweightEntityRealizer) {
            LightweightEntityRealizer ler = (LightweightEntityRealizer)realizer;
            ler.setSizeDirty(true);
        }
    }
}

