/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

#include <functional>
#include <unordered_map>

#include <QMap>


/////////////////////// libXpertMassCore includes
#include "MsXpS/libXpertMassCore/jsclassregistrar.h"


/////////////////////// libXpertMassGUI includes
#include "MsXpS/libXpertMassGui/JavaScriptQObjectExposureRegistry.hpp"


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

namespace MsXpS
{
namespace libXpertMassGui
{

//! Kind of entity handled in a JavaScript object creation operation.
/*!
 * When creating JavaScript objects, define which kind of entity is being
 * created.
 *
 * \sa msXpSlibXpertMassGui::JavaScriptingWnd
 * \sa msXpSlibXpertMassGui::ScriptingObjectTreeWidgetItem
 */
enum ScriptEntityType
{
  UndefinedEntity,
  StringEntity,
  FunctionEntity,
  ArrayOrListEntity,
  QObjectEntity,
  IntegerEntity,
  DoubleEntity
};

class JavaScriptingWnd;
class JavaScriptingGuiUtils;

class DECLSPEC JavaScriptingEnvironment: public QObject
{
  Q_OBJECT

  public:
  explicit JavaScriptingEnvironment(QObject *parent = nullptr);
  virtual ~JavaScriptingEnvironment();
  bool initializeJsEngine() const;

  // Evaluate JavaScript code
  Q_INVOKABLE QJSValue evaluate(const QString &script);
  Q_INVOKABLE QJSValue evaluate(QJSEngine *engine_p, const QString &script);

  Q_INVOKABLE QJSEngine *getJsEngine() const;

  Q_INVOKABLE bool
  exposeQObject(QJSEngine *js_engine_p,
                const QString &name,
                const QString &alias,
                const QString &description,
                QObject *object_p,
                QObject *object_parent_p,
                QJSValue &returned_js_value,
                QJSEngine::ObjectOwnership ownership =
                  QJSEngine::ObjectOwnership::CppOwnership) ;

  Q_INVOKABLE bool exposeQObject(const QString &name,
                                const QString &alias,
                                const QString &description,
                                QObject *object_p,
                                QObject *object_parent_p,
                                QJSValue &returned_js_value,
                                QJSEngine::ObjectOwnership ownership =
                                  QJSEngine::ObjectOwnership::CppOwnership);

  Q_INVOKABLE bool exposeJsValueToJsEngine(const QString &name,
                                           QJSValue &js_value) const;

  QJSValue getExposedJsEngineObjectByName(const QString &name) const;

  void registerJsConstructorForClassInRegistrarMap(
    const QString &name_space,
    const QString &class_name,
    QJSEngine *js_engine_p = nullptr) const;

  void registerJsConstructorForClassesInRegistrarMap(
    const std::vector<std::pair<QString, QString>> &namespace_class_pairs,
    QJSEngine *js_engine_p = nullptr) const;

  void registerJsConstructorForEachClassInRegistrarMap(
    QJSEngine *js_engine_p = nullptr) const;

  void registerOwnJsEntities(QJSEngine *js_engine_p = nullptr) const;
  void registerExternalJsEntities(const QString &name_space,
                                  QJSEngine *js_engine_p = nullptr) const;

  signals:
  void initializeJsEngineSignal(QJSEngine *js_engine_p) const;
  void errorOccurredSignal(const QString &errorMessage) const;

  private:
  QJSEngine *mp_jsEngine;
  JavaScriptQObjectExposureRegistry m_registry;
  JavaScriptingWnd *mp_javaScriptingWnd;
};

} // namespace libXpertMassGui
} // namespace MsXpS
