// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2024 Konrad Twardowski

#include "unlock.h"

// UnlockAction

// public

UnlockAction::UnlockAction() :
	Action(
		i18n("Unlock Screen"),
		"object-unlocked", "unlock"
) {
	setCanBookmark(true);
	setCommandLineOption({ "unlock" });

	setVisibleInMainMenu(false);
	setVisibleInSystemTrayMenu(false);

	auto sm = strategyManager();
	sm->program(Utils::linuxOS, "loginctl", { "unlock-session" });
}

bool UnlockAction::onAction() {
	return strategyManager()->run();
}
