/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.action.HotkeyUtil;
import com.jsql.view.swing.tab.TabbedPaneMouseWheelListener;
import java.awt.Component;
import javax.swing.JTabbedPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabbedPaneWheeled
extends JTabbedPane {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public TabbedPaneWheeled() {
        this(1);
    }

    public TabbedPaneWheeled(int tabPlacement) {
        super(tabPlacement, 1);
        this.addMouseWheelListener(new TabbedPaneMouseWheelListener());
        HotkeyUtil.addShortcut(this);
    }

    public void setBold(String label) {
        int tabIndex = this.indexOfTab(label);
        if (this.getSelectedIndex() != tabIndex && 0 <= tabIndex && tabIndex < this.getTabCount()) {
            Component tabHeader = this.getTabComponentAt(tabIndex);
            try {
                tabHeader.setFont(tabHeader.getFont().deriveFont(1));
            }
            catch (ClassCastException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
    }
}

