/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.jsql.util.I18nUtil;
import com.jsql.view.swing.tab.TabbedPaneWheeled;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.ModelSvgIcon;
import com.jsql.view.swing.util.UiUtil;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JLabel;
import javax.swing.JToolTip;

public class TabManagers
extends TabbedPaneWheeled {
    private final transient List<ModelSvgIcon> iconsTabs = Arrays.asList(UiUtil.DATABASE_BOLD, UiUtil.ADMIN, UiUtil.DOWNLOAD, UiUtil.TERMINAL, UiUtil.LOCK, UiUtil.TEXTFIELD, UiUtil.BATCH);

    public TabManagers() {
        this.setName("tabManagers");
        this.setMaximumSize(new Dimension(this.getMaximumSize().width, 35));
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 35));
        AtomicInteger indexTab = new AtomicInteger();
        this.iconsTabs.forEach(modelSvgIcon -> this.buildI18nTab((ModelSvgIcon)modelSvgIcon, indexTab.getAndIncrement()));
        this.addChangeListener(e -> {
            CardLayout cardLayout = (CardLayout)MediatorHelper.tabManagersCards().getLayout();
            cardLayout.show(MediatorHelper.tabManagersCards(), this.getTabComponentAt(this.getSelectedIndex()).getName());
        });
    }

    private void buildI18nTab(ModelSvgIcon modelSvgIcon, final int index) {
        FlatSVGIcon icon = modelSvgIcon.getIcon();
        String keyLabel = modelSvgIcon.getKeyLabel();
        final String keyTooltip = modelSvgIcon.getKeyTooltip();
        final AtomicReference<JToolTipI18n> tooltipAtomic = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nUtil.valueByKey(keyTooltip)));
        JLabel labelTab = new JLabel(I18nUtil.valueByKey(keyLabel), icon, 0){

            @Override
            public JToolTip createToolTip() {
                tooltipAtomic.set(new JToolTipI18n(I18nUtil.valueByKey(keyTooltip)));
                return (JToolTip)tooltipAtomic.get();
            }
        };
        labelTab.setName(keyLabel);
        labelTab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CardLayout cardLayout = (CardLayout)MediatorHelper.tabManagersCards().getLayout();
                cardLayout.show(MediatorHelper.tabManagersCards(), TabManagers.this.getTabComponentAt(index).getName());
                TabManagers.this.setSelectedIndex(index);
            }
        });
        this.addTab(I18nUtil.valueByKey(keyLabel), icon, null);
        this.setTabComponentAt(this.indexOfTab(I18nUtil.valueByKey(keyLabel)), labelTab);
        I18nViewUtil.addComponentForKey(keyLabel, labelTab);
        I18nViewUtil.addComponentForKey(keyTooltip, tooltipAtomic.get());
        labelTab.setToolTipText(I18nUtil.valueByKey(keyTooltip));
    }

    public List<ModelSvgIcon> getIconsTabs() {
        return this.iconsTabs;
    }
}

