/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.list;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.MenuActionExport;
import com.jsql.view.swing.list.MenuActionNewValue;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.ComponentOrientation;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MouseAdapterMenuAction
extends MouseAdapter {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final DnDList dndList;

    public MouseAdapterMenuAction(DnDList dndList) {
        this.dndList = dndList;
    }

    public void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JList list = (JList)mouseEvent.getSource();
            JPopupMenu popupMenuList = this.initMenu(mouseEvent);
            popupMenuList.applyComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()));
            try {
                popupMenuList.show(list, ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? mouseEvent.getX() - popupMenuList.getWidth() : mouseEvent.getX(), mouseEvent.getY());
            }
            catch (IllegalComponentStateException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
            popupMenuList.setLocation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? mouseEvent.getXOnScreen() - popupMenuList.getWidth() : mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
        }
    }

    private JPopupMenu initMenu(MouseEvent mouseEvent) {
        JPopupMenu popupMenuList = new JPopupMenu();
        boolean isNonUbuntu = I18nViewUtil.isNonUbuntu(I18nUtil.getCurrentLocale());
        JMenuItem menuImport = new JMenuItem();
        JMenuItem menuExport = new JMenuItem();
        JMenuItem menuCut = new JMenuItem();
        JMenuItem menuCopy = new JMenuItem();
        JMenuItem menuPaste = new JMenuItem();
        JMenuItem menuDelete = new JMenuItem();
        JMenuItem menuNew = new JMenuItem();
        JMenuItem menuRestoreDefault = new JMenuItem();
        JMenuItem menuSelectAll = new JMenuItem();
        Stream.of(new AbstractMap.SimpleEntry<JMenuItem, String>(menuImport, "LIST_IMPORT_CONFIRM_TITLE"), new AbstractMap.SimpleEntry<JMenuItem, String>(menuExport, "LIST_EXPORT_TITLE"), new AbstractMap.SimpleEntry<JMenuItem, String>(menuCut, "LIST_CUT"), new AbstractMap.SimpleEntry<JMenuItem, String>(menuCopy, "CONTEXT_MENU_COPY"), new AbstractMap.SimpleEntry<JMenuItem, String>(menuPaste, "LIST_PASTE"), new AbstractMap.SimpleEntry<JMenuItem, String>(menuDelete, "LIST_DELETE"), new AbstractMap.SimpleEntry<JMenuItem, String>(menuNew, "LIST_NEW_VALUE"), new AbstractMap.SimpleEntry<JMenuItem, String>(menuRestoreDefault, "LIST_RESTORE_DEFAULT"), new AbstractMap.SimpleEntry<JMenuItem, String>(menuSelectAll, "CONTEXT_MENU_SELECT_ALL")).forEach(entry -> {
            ((JMenuItem)entry.getKey()).setText(isNonUbuntu ? I18nViewUtil.valueByKey((String)entry.getValue()) : I18nUtil.valueByKey((String)entry.getValue()));
            ((JMenuItem)entry.getKey()).setName((String)entry.getValue());
            I18nViewUtil.addComponentForKey((String)entry.getValue(), entry.getKey());
        });
        menuCut.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        menuCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        menuPaste.setAccelerator(KeyStroke.getKeyStroke(86, 128));
        menuSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        JFileChooser importFileDialog = new JFileChooser(MediatorHelper.model().getMediatorUtils().getPreferencesUtil().getPathFile());
        importFileDialog.setDialogTitle(I18nUtil.valueByKey("LIST_IMPORT_CONFIRM_TITLE"));
        importFileDialog.setMultiSelectionEnabled(true);
        menuNew.addActionListener(new MenuActionNewValue(this.dndList));
        menuImport.addActionListener(actionEvent -> {
            int choice = 0;
            try {
                choice = importFileDialog.showOpenDialog(this.dndList.getTopLevelAncestor());
            }
            catch (ClassCastException | NullPointerException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
            if (choice == 0) {
                this.dndList.dropPasteFile(Arrays.asList(importFileDialog.getSelectedFiles()), this.dndList.locationToIndex(mouseEvent.getPoint()));
            }
        });
        menuCopy.addActionListener(actionEvent -> {
            Action action = this.dndList.getActionMap().get(TransferHandler.getCopyAction().getValue("Name"));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this.dndList, 1001, null));
            }
        });
        menuCut.addActionListener(actionEvent -> {
            Action action = this.dndList.getActionMap().get(TransferHandler.getCutAction().getValue("Name"));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this.dndList, 1001, null));
            }
        });
        menuPaste.addActionListener(actionEvent -> {
            Action action = this.dndList.getActionMap().get(TransferHandler.getPasteAction().getValue("Name"));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this.dndList, 1001, null));
            }
        });
        menuDelete.addActionListener(actionEvent -> this.dndList.removeSelectedItem());
        menuExport.addActionListener(new MenuActionExport(this.dndList));
        menuRestoreDefault.addActionListener(actionEvent -> this.dndList.restore());
        menuSelectAll.addActionListener(actionEvent -> {
            int start = 0;
            int end = this.dndList.getModel().getSize() - 1;
            if (end >= 0) {
                this.dndList.setSelectionInterval(start, end);
            }
        });
        popupMenuList.add(menuNew);
        popupMenuList.add(new JSeparator());
        popupMenuList.add(menuCut);
        popupMenuList.add(menuCopy);
        popupMenuList.add(menuPaste);
        popupMenuList.add(menuDelete);
        popupMenuList.add(new JSeparator());
        popupMenuList.add(menuSelectAll);
        popupMenuList.add(new JSeparator());
        popupMenuList.add(menuImport);
        popupMenuList.add(menuExport);
        popupMenuList.add(new JSeparator());
        popupMenuList.add(menuRestoreDefault);
        return popupMenuList;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            int clickIndex = this.dndList.locationToIndex(e.getPoint());
            boolean containsIndex = false;
            for (int currentIndex : this.dndList.getSelectedIndices()) {
                if (currentIndex != clickIndex) continue;
                containsIndex = true;
                break;
            }
            if (!containsIndex) {
                this.dndList.setSelectedIndex(clickIndex);
            }
        }
        this.showPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showPopup(e);
    }
}

