/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBit;
import com.jsql.model.injection.strategy.blind.InjectionBlindBin;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrategyBlindBin
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private InjectionBlindBin injectionBlindBin;

    public StrategyBlindBin(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public void checkApplicability() throws StoppedByUserSlidingException {
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isStrategyBlindBinDisabled()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Skipping strategy [{}] disabled", (Object)this.getName());
            return;
        }
        if (StringUtils.isEmpty(this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getStrategy().getBinary().getTest().getBin())) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Strategy [{}] for [{}] not implemented, share a working example to GitHub to speed up release", (Object)this.getName(), (Object)this.injectionModel.getMediatorVendor().getVendor());
            return;
        }
        this.checkInjection(AbstractInjectionBit.BlindOperator.OR);
        this.checkInjection(AbstractInjectionBit.BlindOperator.AND);
        this.checkInjection(AbstractInjectionBit.BlindOperator.STACK);
        this.checkInjection(AbstractInjectionBit.BlindOperator.NO_MODE);
        if (this.isApplicable) {
            this.allow(new int[0]);
            Request requestMessageBinary = new Request();
            requestMessageBinary.setMessage(Interaction.MESSAGE_BINARY);
            requestMessageBinary.setParameters(this.injectionBlindBin.getInfoMessage());
            this.injectionModel.sendToViews(requestMessageBinary);
        } else {
            this.unallow(new int[0]);
        }
    }

    private void checkInjection(AbstractInjectionBit.BlindOperator blindOperator) throws StoppedByUserSlidingException {
        if (this.isApplicable) {
            return;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} [{}] with [{}]...", () -> I18nUtil.valueByKey("LOG_CHECKING_STRATEGY"), this::getName, () -> blindOperator);
        this.injectionBlindBin = new InjectionBlindBin(this.injectionModel, blindOperator);
        this.isApplicable = this.injectionBlindBin.isInjectable();
        if (this.isApplicable) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} [{}] injection with [{}]", () -> I18nUtil.valueByKey("LOG_VULNERABLE"), this::getName, () -> blindOperator);
        }
    }

    @Override
    public void allow(int ... i) {
        this.injectionModel.appendAnalysisReport(StringUtil.formatReport(LogLevelUtil.COLOR_BLU, "### Strategy: " + this.getName()) + this.injectionModel.getReportWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTestBlindWithOperator(this.injectionModel.getMediatorVendor().getVendor().instance().sqlBlind(StringUtil.formatReport(LogLevelUtil.COLOR_GREEN, "&lt;query&gt;"), "0", true), this.injectionBlindBin.getBooleanMode()), "metadataInjectionProcess", null));
        this.markVulnerability(Interaction.MARK_BLIND_BIN_VULNERABLE, new int[0]);
    }

    @Override
    public void unallow(int ... i) {
        this.markVulnerability(Interaction.MARK_BLIND_BIN_INVULNERABLE, new int[0]);
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) throws StoppedByUserSlidingException {
        return this.injectionBlindBin.inject(this.injectionModel.getMediatorVendor().getVendor().instance().sqlBlind(sqlQuery, startPosition, false), stoppable);
    }

    @Override
    public void activateWhenApplicable() {
        if (this.injectionModel.getMediatorStrategy().getStrategy() == null && this.isApplicable()) {
            LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} [{}] with [{}]", () -> I18nUtil.valueByKey("LOG_USING_STRATEGY"), this::getName, () -> this.injectionBlindBin.getBooleanMode().name());
            this.injectionModel.getMediatorStrategy().setStrategy(this);
            Request request = new Request();
            request.setMessage(Interaction.MARK_BLIND_BIN_STRATEGY);
            this.injectionModel.sendToViews(request);
        }
    }

    @Override
    public String getPerformanceLength() {
        return "65565";
    }

    @Override
    public String getName() {
        return "Blind bin";
    }
}

