/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.panel;

import com.jsql.model.InjectionModel;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.console.JTextPaneAppender;
import com.jsql.view.swing.console.SimpleConsoleAdapter;
import com.jsql.view.swing.panel.consoles.NetworkTable;
import com.jsql.view.swing.panel.consoles.TabbedPaneNetworkTab;
import com.jsql.view.swing.panel.split.SplitNS;
import com.jsql.view.swing.tab.TabbedPaneWheeled;
import com.jsql.view.swing.text.JPopupTextArea;
import com.jsql.view.swing.text.JTextAreaPlaceholderConsole;
import com.jsql.view.swing.text.JToolTipI18n;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PanelConsoles
extends JPanel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String CONSOLE_JAVA_TOOLTIP = "CONSOLE_JAVA_TOOLTIP";
    public static final String CONSOLE_CHUNK_TOOLTIP = "CONSOLE_CHUNK_TOOLTIP";
    public static final String CONSOLE_BINARY_TOOLTIP = "CONSOLE_BINARY_TOOLTIP";
    public static final String CONSOLE_MAIN_TOOLTIP = "CONSOLE_MAIN_TOOLTIP";
    private final SimpleConsoleAdapter javaTextPane = new SimpleConsoleAdapter("Java", I18nUtil.valueByKey("CONSOLE_JAVA_TOOLTIP"));
    private JTextArea chunkTextArea;
    private JSplitPane networkSplitPane;
    private JTextArea binaryTextArea;
    private final TabbedPaneWheeled tabConsoles = new TabbedPaneWheeled();
    private TabbedPaneNetworkTab tabbedPaneNetworkTab;
    private NetworkTable networkTable;
    private final JLabel labelShowNorth = new JLabel(UiUtil.ARROW_UP.getIcon());
    private int dividerLocation = 0;

    public PanelConsoles() {
        I18nViewUtil.addComponentForKey(CONSOLE_JAVA_TOOLTIP, this.javaTextPane.getProxy());
        ((JTextPane)this.javaTextPane.getProxy()).setEditable(false);
        JTextPaneAppender.registerJavaConsole(this.javaTextPane);
        this.initSplit();
        MediatorHelper.register(this.tabConsoles);
        this.initTabsConsoles();
        this.setLayout(new BorderLayout());
        JPanel expandPanel = this.initExpandPanel();
        this.tabConsoles.putClientProperty("JTabbedPane.trailingComponent", expandPanel);
        this.add(this.tabConsoles);
        this.tabConsoles.setAlignmentX(3.0f);
    }

    private void initSplit() {
        this.networkSplitPane = new JSplitPane(1);
        this.networkSplitPane.setDividerLocation(600);
        this.networkSplitPane.setPreferredSize(new Dimension(0, 0));
        this.tabbedPaneNetworkTab = new TabbedPaneNetworkTab();
        this.networkSplitPane.setRightComponent(this.tabbedPaneNetworkTab);
        this.networkTable = new NetworkTable(this.tabbedPaneNetworkTab);
        JPanel panelTable = new JPanel(new BorderLayout());
        panelTable.add((Component)new JScrollPane(this.networkTable), "Center");
        this.networkSplitPane.setLeftComponent(panelTable);
    }

    private void initTabsConsoles() {
        JTextAreaPlaceholderConsole proxyChunk = new JTextAreaPlaceholderConsole(I18nUtil.valueByKey(CONSOLE_CHUNK_TOOLTIP));
        this.chunkTextArea = (JTextArea)new JPopupTextArea(proxyChunk).getProxy();
        I18nViewUtil.addComponentForKey(CONSOLE_CHUNK_TOOLTIP, proxyChunk);
        this.chunkTextArea.setLineWrap(true);
        this.chunkTextArea.setEditable(false);
        JTextAreaPlaceholderConsole proxyBinary = new JTextAreaPlaceholderConsole(I18nUtil.valueByKey(CONSOLE_BINARY_TOOLTIP));
        I18nViewUtil.addComponentForKey(CONSOLE_BINARY_TOOLTIP, proxyBinary);
        this.binaryTextArea = (JTextArea)new JPopupTextArea(proxyBinary).getProxy();
        this.binaryTextArea.setLineWrap(true);
        this.binaryTextArea.setEditable(false);
        SimpleConsoleAdapter consoleTextPane = new SimpleConsoleAdapter("Console", I18nUtil.valueByKey(CONSOLE_MAIN_TOOLTIP));
        I18nViewUtil.addComponentForKey(CONSOLE_MAIN_TOOLTIP, consoleTextPane.getProxy());
        ((JTextPane)consoleTextPane.getProxy()).setEditable(false);
        JTextPaneAppender.register(consoleTextPane);
        this.buildI18nTab("CONSOLE_MAIN_LABEL", CONSOLE_MAIN_TOOLTIP, UiUtil.CONSOLE.getIcon(), new JScrollPane(consoleTextPane.getProxy()), 0);
        Preferences preferences = Preferences.userRoot().node(InjectionModel.class.getName());
        if (preferences.getBoolean("java_visible", false)) {
            this.insertJavaTab();
        }
        if (preferences.getBoolean("header_visible", true)) {
            this.insertNetworkTab();
        }
        if (preferences.getBoolean("chunk_visible", true)) {
            this.insertChunkTab();
        }
        if (preferences.getBoolean("binary_visible", true)) {
            this.insertBooleanTab();
        }
        this.tabConsoles.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int tabIndex = PanelConsoles.this.tabConsoles.indexAtLocation(e.getX(), e.getY());
                if (tabIndex == -1 && e.getButton() == 2) {
                    SplitNS.getActionHideShowConsole().actionPerformed(null);
                }
            }
        });
        this.tabConsoles.addChangeListener(changeEvent -> {
            Component currentTabHeader;
            TabbedPaneWheeled tabs = this.tabConsoles;
            if (tabs.getSelectedIndex() > -1 && (currentTabHeader = tabs.getTabComponentAt(tabs.getSelectedIndex())) != null) {
                currentTabHeader.setFont(currentTabHeader.getFont().deriveFont(0));
                currentTabHeader.setForeground(UIManager.getColor("TabbedPane.foreground"));
            }
        });
    }

    private JPanel initExpandPanel() {
        JLabel labelShowSouth = new JLabel(UiUtil.ARROW_DOWN.getIcon());
        labelShowSouth.setName("buttonShowSouth");
        labelShowSouth.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SplitNS.getActionHideShowConsole().actionPerformed(null);
            }
        });
        this.labelShowNorth.setName("buttonShowNorth");
        this.labelShowNorth.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SplitNS.getActionHideShowResult().actionPerformed(null);
            }
        });
        JPanel panelExpander = new JPanel();
        panelExpander.setLayout(new BoxLayout(panelExpander, 0));
        panelExpander.add(Box.createGlue());
        panelExpander.add(this.labelShowNorth);
        panelExpander.add(labelShowSouth);
        return panelExpander;
    }

    public void reset() {
        this.chunkTextArea.setText("");
        this.binaryTextArea.setText("");
        ((JTextPane)this.javaTextPane.getProxy()).setText("");
        this.networkTable.getListHttpHeader().clear();
        try {
            ((DefaultTableModel)this.networkTable.getModel()).setRowCount(0);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        this.tabbedPaneNetworkTab.reset();
    }

    public void insertChunkTab() {
        this.buildI18nTab("CONSOLE_CHUNK_LABEL", CONSOLE_CHUNK_TOOLTIP, UiUtil.CHUNK.getIcon(), new JScrollPane(this.chunkTextArea), 1);
    }

    public void insertBooleanTab() {
        int positionFromChunk = this.tabConsoles.indexOfTab(UiUtil.CHUNK.getIcon()) != -1 ? 1 : 0;
        this.buildI18nTab("CONSOLE_BINARY_LABEL", CONSOLE_BINARY_TOOLTIP, UiUtil.BINARY.getIcon(), new JScrollPane(this.binaryTextArea), 1 + positionFromChunk);
    }

    public void insertNetworkTab() {
        int positionFromJava = this.tabConsoles.indexOfTab(UiUtil.CUP.getIcon()) != -1 ? 1 : 0;
        this.buildI18nTab("CONSOLE_NETWORK_LABEL", "CONSOLE_NETWORK_TOOLTIP", UiUtil.NETWORK.getIcon(), new JScrollPane(this.networkSplitPane), this.tabConsoles.getTabCount() - positionFromJava);
    }

    public void insertJavaTab() {
        this.buildI18nTab("CONSOLE_JAVA_LABEL", CONSOLE_JAVA_TOOLTIP, UiUtil.CUP.getIcon(), new JScrollPane(this.javaTextPane.getProxy()), this.tabConsoles.getTabCount());
    }

    private void buildI18nTab(String keyLabel, final String keyTooltip, Icon icon, final Component manager, int position) {
        final AtomicReference<JToolTipI18n> refJToolTipI18n = new AtomicReference<JToolTipI18n>(new JToolTipI18n(I18nViewUtil.valueByKey(keyTooltip)));
        JLabel labelTab = new JLabel(I18nViewUtil.valueByKey(keyLabel), icon, 0){

            @Override
            public JToolTip createToolTip() {
                refJToolTipI18n.set(new JToolTipI18n(I18nViewUtil.valueByKey(keyTooltip)));
                return (JToolTip)refJToolTipI18n.get();
            }
        };
        labelTab.setName(keyLabel);
        labelTab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                try {
                    PanelConsoles.this.tabConsoles.setSelectedComponent(manager);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
                }
            }
        });
        this.tabConsoles.insertTab(I18nViewUtil.valueByKey(keyLabel), icon, manager, null, position);
        this.tabConsoles.setTabComponentAt(this.tabConsoles.indexOfTab(I18nViewUtil.valueByKey(keyLabel)), labelTab);
        I18nViewUtil.addComponentForKey(keyLabel, labelTab);
        I18nViewUtil.addComponentForKey(keyTooltip, refJToolTipI18n.get());
        labelTab.setToolTipText(I18nViewUtil.valueByKey(keyTooltip));
    }

    public void messageChunk(String text) {
        try {
            this.chunkTextArea.append(text + "\n");
            this.chunkTextArea.setCaretPosition(this.chunkTextArea.getDocument().getLength());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e.getMessage(), (Throwable)e);
        }
    }

    public void messageBinary(String text) {
        try {
            this.binaryTextArea.append(String.format("\t%s", text));
            this.binaryTextArea.setCaretPosition(this.binaryTextArea.getDocument().getLength());
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e.getMessage(), (Throwable)e);
        }
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(int location) {
        this.dividerLocation = location;
    }

    public JLabel getLabelShowNorth() {
        return this.labelShowNorth;
    }

    public NetworkTable getNetworkTable() {
        return this.networkTable;
    }

    public TabbedPaneNetworkTab getTabbedPaneNetworkTab() {
        return this.tabbedPaneNetworkTab;
    }
}

