/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlRuntimeException;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Locale;
import javax.swing.UIManager;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private JSONObject jsonObject;
    private final InjectionModel injectionModel;

    public GitUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void checkUpdate(ShowOnConsole displayUpdateMessage) {
        if (displayUpdateMessage == ShowOnConsole.YES) {
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, () -> I18nUtil.valueByKey("UPDATE_LOADING"));
        }
        try {
            float versionGit = Float.parseFloat(this.callService().getString("version"));
            if (versionGit > Float.parseFloat(this.injectionModel.getPropertiesUtil().getVersionJsql())) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, () -> I18nUtil.valueByKey("UPDATE_NEW_VERSION"));
            } else if (displayUpdateMessage == ShowOnConsole.YES) {
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, () -> I18nUtil.valueByKey("UPDATE_UPTODATE"));
            }
        }
        catch (NumberFormatException | JSONException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, I18nUtil.valueByKey("UPDATE_EXCEPTION"));
        }
    }

    public void sendUnhandledException(String threadName, Throwable throwable) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)screenSize.getWidth();
        int height = (int)screenSize.getHeight();
        String osMetadata = String.join((CharSequence)"\n", String.format("jSQL: v%s", this.injectionModel.getPropertiesUtil().getVersionJsql()), String.format("Java: v%s-%s-%s on %s%s", SystemUtils.JAVA_VERSION, SystemUtils.OS_ARCH, SystemUtils.USER_LANGUAGE, SystemUtils.JAVA_VENDOR, SystemUtils.JAVA_RUNTIME_NAME), String.format("OS: %s (v%s)", SystemUtils.OS_NAME, SystemUtils.OS_VERSION), String.format("Display: %s (%sx%s, %s)", UIManager.getLookAndFeel().getName(), width, height, Locale.getDefault().getLanguage()), String.format("Strategy: %s", this.injectionModel.getMediatorStrategy().getStrategy() != null ? this.injectionModel.getMediatorStrategy().getStrategy().getName() : "undefined"), String.format("Db engine: %s", this.injectionModel.getMediatorVendor().getVendor().toString()));
        String exceptionText = String.format("Exception on %s%n%s%n", threadName, ExceptionUtils.getStackTrace(throwable).trim());
        String clientDescription = String.format("```yaml%n%s%n```%n```java%n%s```", osMetadata, exceptionText);
        clientDescription = clientDescription.replaceAll("(https?://[.a-zA-Z_0-9]*)+", "");
        this.sendReport(clientDescription, ShowOnConsole.NO, "Unhandled " + throwable.getClass().getSimpleName());
    }

    public void sendReport(String reportBody, ShowOnConsole showOnConsole, String reportTitle) {
        block6: {
            String token;
            if (this.injectionModel.getMediatorUtils().getProxyUtil().isNotLive(showOnConsole)) {
                return;
            }
            try {
                token = StringUtil.fromHexZip(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperty("jsql.hash"));
            }
            catch (IOException e) {
                throw new JSqlRuntimeException(e);
            }
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperty("github.issues.url"))).setHeader("Authorization", "token " + token).POST(HttpRequest.BodyPublishers.ofString(new JSONObject().put("title", reportTitle).put("body", reportBody).toString())).timeout(Duration.ofSeconds(15L)).build();
            try {
                HttpResponse<String> response = this.injectionModel.getMediatorUtils().getConnectionUtil().getHttpClient().build().send(httpRequest, HttpResponse.BodyHandlers.ofString());
                this.readGithubResponse(response, showOnConsole);
            }
            catch (IOException | InterruptedException e) {
                if (showOnConsole == ShowOnConsole.YES) {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("Error during GitHub report connection: %s", e.getMessage()));
                }
                if (!(e instanceof InterruptedException)) break block6;
                Thread.currentThread().interrupt();
            }
        }
    }

    private void readGithubResponse(HttpResponse<String> response, ShowOnConsole showOnConsole) throws IOException {
        try {
            if (showOnConsole == ShowOnConsole.YES) {
                JSONObject jsonObjectResponse = new JSONObject(response.body());
                String urlIssue = jsonObjectResponse.getString("html_url");
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Sent to GitHub: {}", (Object)urlIssue);
            }
        }
        catch (Exception e) {
            throw new IOException("Connection to the GitHub API failed, check your connection or update jSQL");
        }
    }

    public void showNews() {
        try {
            JSONArray news = this.callService().getJSONArray("news");
            for (int index = 0; index < news.length(); ++index) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, news.get(index));
            }
        }
        catch (JSONException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Connection to the GitHub API failed");
        }
    }

    public JSONObject callService() {
        if (this.jsonObject == null) {
            String json = this.injectionModel.getMediatorUtils().getConnectionUtil().getSource(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperty("github.webservice.url"));
            try {
                this.jsonObject = new JSONObject(json);
            }
            catch (JSONException e) {
                try {
                    this.jsonObject = new JSONObject("{\"version\": \"0\", \"news\": []}");
                }
                catch (JSONException eInner) {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Fetching default JSON failed", (Throwable)eInner);
                }
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Fetching configuration from GitHub failed. Wait for service to be available, check your connection or update jSQL");
            }
        }
        return this.jsonObject;
    }

    public static enum ShowOnConsole {
        YES,
        NO;

    }
}

