# Generated by Django 2.2.17 on 2021-02-27 17:14
from dojo.tools.npm_audit.parser import censor_path_hashes
from dojo.utils import mass_model_updater
from django.db import migrations
from django.utils import timezone
import logging
logger = logging.getLogger(__name__)


def censor_hashes(finding):
    finding.file_path = censor_path_hashes(finding.file_path)
    # we can't access the compute_hash_code method in migrations
    # so a separate run of ./manage.py dedupe --hash_code_only is needed
    return finding


def npm_censor_hashes(apps, schema_editor):
    # We can't import the models directly as it may be a newer
    # version than this migration expects. We use the historical version.
    logger.info('Removing random hashes from npm audit file_paths')

    now = timezone.now()
    Finding = apps.get_model('dojo', 'Finding')
    Test_Type = apps.get_model('dojo', 'Test_Type')
    npm_audit, _ = Test_Type.objects.get_or_create(name='NPM Audit Scan')
    findings = Finding.objects.filter(test__test_type=npm_audit)

    mass_model_updater(Finding, findings, lambda f: censor_hashes(f), fields=['file_path', 'hash_code'])


class Migration(migrations.Migration):

    dependencies = [
        ('dojo', '0090_index_duplicate_finding'),
    ]

    operations = [
        migrations.RunPython(npm_censor_hashes, migrations.RunPython.noop),
    ]
